/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response from retrieving a dataview, which includes details on the target database and table name
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataViewResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetDataViewResponse.Builder, GetDataViewResponse> {
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoUpdate").getter(getter(GetDataViewResponse::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()).build();

    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("partitionColumns")
            .getter(getter(GetDataViewResponse::partitionColumns))
            .setter(setter(Builder::partitionColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(GetDataViewResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<Long> AS_OF_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("asOfTimestamp").getter(getter(GetDataViewResponse::asOfTimestamp))
            .setter(setter(Builder::asOfTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asOfTimestamp").build()).build();

    private static final SdkField<DataViewErrorInfo> ERROR_INFO_FIELD = SdkField
            .<DataViewErrorInfo> builder(MarshallingType.SDK_POJO).memberName("errorInfo")
            .getter(getter(GetDataViewResponse::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(DataViewErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(GetDataViewResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createTime").getter(getter(GetDataViewResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<List<String>> SORT_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sortColumns")
            .getter(getter(GetDataViewResponse::sortColumns))
            .setter(setter(Builder::sortColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataViewId").getter(getter(GetDataViewResponse::dataViewId)).setter(setter(Builder::dataViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewId").build()).build();

    private static final SdkField<String> DATA_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataViewArn").getter(getter(GetDataViewResponse::dataViewArn)).setter(setter(Builder::dataViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataViewArn").build()).build();

    private static final SdkField<DataViewDestinationTypeParams> DESTINATION_TYPE_PARAMS_FIELD = SdkField
            .<DataViewDestinationTypeParams> builder(MarshallingType.SDK_POJO).memberName("destinationTypeParams")
            .getter(getter(GetDataViewResponse::destinationTypeParams)).setter(setter(Builder::destinationTypeParams))
            .constructor(DataViewDestinationTypeParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTypeParams").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDataViewResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_UPDATE_FIELD,
            PARTITION_COLUMNS_FIELD, DATASET_ID_FIELD, AS_OF_TIMESTAMP_FIELD, ERROR_INFO_FIELD, LAST_MODIFIED_TIME_FIELD,
            CREATE_TIME_FIELD, SORT_COLUMNS_FIELD, DATA_VIEW_ID_FIELD, DATA_VIEW_ARN_FIELD, DESTINATION_TYPE_PARAMS_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean autoUpdate;

    private final List<String> partitionColumns;

    private final String datasetId;

    private final Long asOfTimestamp;

    private final DataViewErrorInfo errorInfo;

    private final Long lastModifiedTime;

    private final Long createTime;

    private final List<String> sortColumns;

    private final String dataViewId;

    private final String dataViewArn;

    private final DataViewDestinationTypeParams destinationTypeParams;

    private final String status;

    private GetDataViewResponse(BuilderImpl builder) {
        super(builder);
        this.autoUpdate = builder.autoUpdate;
        this.partitionColumns = builder.partitionColumns;
        this.datasetId = builder.datasetId;
        this.asOfTimestamp = builder.asOfTimestamp;
        this.errorInfo = builder.errorInfo;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createTime = builder.createTime;
        this.sortColumns = builder.sortColumns;
        this.dataViewId = builder.dataViewId;
        this.dataViewArn = builder.dataViewArn;
        this.destinationTypeParams = builder.destinationTypeParams;
        this.status = builder.status;
    }

    /**
     * <p>
     * Flag to indicate Dataview should be updated automatically.
     * </p>
     * 
     * @return Flag to indicate Dataview should be updated automatically.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionColumns() {
        return partitionColumns != null && !(partitionColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Ordered set of column names used to partition data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionColumns} method.
     * </p>
     * 
     * @return Ordered set of column names used to partition data.
     */
    public final List<String> partitionColumns() {
        return partitionColumns;
    }

    /**
     * <p>
     * The unique identifier for the Dataset used in the Dataview.
     * </p>
     * 
     * @return The unique identifier for the Dataset used in the Dataview.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the value
     * for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example,
     *         the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long asOfTimestamp() {
        return asOfTimestamp;
    }

    /**
     * <p>
     * Information about an error that occurred for the Dataview.
     * </p>
     * 
     * @return Information about an error that occurred for the Dataview.
     */
    public final DataViewErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Long createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortColumns() {
        return sortColumns != null && !(sortColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Columns to be used for sorting the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortColumns} method.
     * </p>
     * 
     * @return Columns to be used for sorting the data.
     */
    public final List<String> sortColumns() {
        return sortColumns;
    }

    /**
     * <p>
     * The unique identifier for the Dataview.
     * </p>
     * 
     * @return The unique identifier for the Dataview.
     */
    public final String dataViewId() {
        return dataViewId;
    }

    /**
     * <p>
     * The ARN identifier of the Dataview.
     * </p>
     * 
     * @return The ARN identifier of the Dataview.
     */
    public final String dataViewArn() {
        return dataViewArn;
    }

    /**
     * <p>
     * Options that define the destination type for the Dataview.
     * </p>
     * 
     * @return Options that define the destination type for the Dataview.
     */
    public final DataViewDestinationTypeParams destinationTypeParams() {
        return destinationTypeParams;
    }

    /**
     * <p>
     * The status of a Dataview creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> – Dataview creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> – Dataview creation is starting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Dataview creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – Dataview creation has been cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code> – Dataview creation has timed out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Dataview creation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> – Dataview creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a Dataview creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – Dataview creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> – Dataview creation is starting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Dataview creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – Dataview creation has been cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code> – Dataview creation has timed out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Dataview creation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Dataview creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
     *         </p>
     *         </li>
     * @see DataViewStatus
     */
    public final DataViewStatus status() {
        return DataViewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a Dataview creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> – Dataview creation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code> – Dataview creation is starting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Dataview creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> – Dataview creation has been cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code> – Dataview creation has timed out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Dataview creation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> – Dataview creation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a Dataview creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – Dataview creation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code> – Dataview creation is starting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Dataview creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> – Dataview creation has been cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code> – Dataview creation has timed out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Dataview creation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Dataview creation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
     *         </p>
     *         </li>
     * @see DataViewStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionColumns() ? partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(asOfTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortColumns() ? sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataViewId());
        hashCode = 31 * hashCode + Objects.hashCode(dataViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeParams());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataViewResponse)) {
            return false;
        }
        GetDataViewResponse other = (GetDataViewResponse) obj;
        return Objects.equals(autoUpdate(), other.autoUpdate()) && hasPartitionColumns() == other.hasPartitionColumns()
                && Objects.equals(partitionColumns(), other.partitionColumns()) && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(asOfTimestamp(), other.asOfTimestamp()) && Objects.equals(errorInfo(), other.errorInfo())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(createTime(), other.createTime()) && hasSortColumns() == other.hasSortColumns()
                && Objects.equals(sortColumns(), other.sortColumns()) && Objects.equals(dataViewId(), other.dataViewId())
                && Objects.equals(dataViewArn(), other.dataViewArn())
                && Objects.equals(destinationTypeParams(), other.destinationTypeParams())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataViewResponse").add("AutoUpdate", autoUpdate())
                .add("PartitionColumns", hasPartitionColumns() ? partitionColumns() : null).add("DatasetId", datasetId())
                .add("AsOfTimestamp", asOfTimestamp()).add("ErrorInfo", errorInfo()).add("LastModifiedTime", lastModifiedTime())
                .add("CreateTime", createTime()).add("SortColumns", hasSortColumns() ? sortColumns() : null)
                .add("DataViewId", dataViewId()).add("DataViewArn", dataViewArn())
                .add("DestinationTypeParams", destinationTypeParams()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        case "partitionColumns":
            return Optional.ofNullable(clazz.cast(partitionColumns()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "asOfTimestamp":
            return Optional.ofNullable(clazz.cast(asOfTimestamp()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "sortColumns":
            return Optional.ofNullable(clazz.cast(sortColumns()));
        case "dataViewId":
            return Optional.ofNullable(clazz.cast(dataViewId()));
        case "dataViewArn":
            return Optional.ofNullable(clazz.cast(dataViewArn()));
        case "destinationTypeParams":
            return Optional.ofNullable(clazz.cast(destinationTypeParams()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoUpdate", AUTO_UPDATE_FIELD);
        map.put("partitionColumns", PARTITION_COLUMNS_FIELD);
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("asOfTimestamp", AS_OF_TIMESTAMP_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("sortColumns", SORT_COLUMNS_FIELD);
        map.put("dataViewId", DATA_VIEW_ID_FIELD);
        map.put("dataViewArn", DATA_VIEW_ARN_FIELD);
        map.put("destinationTypeParams", DESTINATION_TYPE_PARAMS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataViewResponse, T> g) {
        return obj -> g.apply((GetDataViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataViewResponse> {
        /**
         * <p>
         * Flag to indicate Dataview should be updated automatically.
         * </p>
         * 
         * @param autoUpdate
         *        Flag to indicate Dataview should be updated automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);

        /**
         * <p>
         * Ordered set of column names used to partition data.
         * </p>
         * 
         * @param partitionColumns
         *        Ordered set of column names used to partition data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionColumns(Collection<String> partitionColumns);

        /**
         * <p>
         * Ordered set of column names used to partition data.
         * </p>
         * 
         * @param partitionColumns
         *        Ordered set of column names used to partition data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionColumns(String... partitionColumns);

        /**
         * <p>
         * The unique identifier for the Dataset used in the Dataview.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for the Dataset used in the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the
         * value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param asOfTimestamp
         *        Time range to use for the Dataview. The value is determined as epoch time in milliseconds. For
         *        example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asOfTimestamp(Long asOfTimestamp);

        /**
         * <p>
         * Information about an error that occurred for the Dataview.
         * </p>
         * 
         * @param errorInfo
         *        Information about an error that occurred for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(DataViewErrorInfo errorInfo);

        /**
         * <p>
         * Information about an error that occurred for the Dataview.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataViewErrorInfo.Builder} avoiding the
         * need to create one manually via {@link DataViewErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataViewErrorInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #errorInfo(DataViewErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link DataViewErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(DataViewErrorInfo)
         */
        default Builder errorInfo(Consumer<DataViewErrorInfo.Builder> errorInfo) {
            return errorInfo(DataViewErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that a Dataview was modified. The value is determined as epoch time in milliseconds. For
         *        example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createTime
         *        The timestamp at which the Dataview was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * Columns to be used for sorting the data.
         * </p>
         * 
         * @param sortColumns
         *        Columns to be used for sorting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(Collection<String> sortColumns);

        /**
         * <p>
         * Columns to be used for sorting the data.
         * </p>
         * 
         * @param sortColumns
         *        Columns to be used for sorting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(String... sortColumns);

        /**
         * <p>
         * The unique identifier for the Dataview.
         * </p>
         * 
         * @param dataViewId
         *        The unique identifier for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataViewId(String dataViewId);

        /**
         * <p>
         * The ARN identifier of the Dataview.
         * </p>
         * 
         * @param dataViewArn
         *        The ARN identifier of the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataViewArn(String dataViewArn);

        /**
         * <p>
         * Options that define the destination type for the Dataview.
         * </p>
         * 
         * @param destinationTypeParams
         *        Options that define the destination type for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams);

        /**
         * <p>
         * Options that define the destination type for the Dataview.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataViewDestinationTypeParams.Builder}
         * avoiding the need to create one manually via {@link DataViewDestinationTypeParams#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataViewDestinationTypeParams.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationTypeParams(DataViewDestinationTypeParams)}.
         * 
         * @param destinationTypeParams
         *        a consumer that will call methods on {@link DataViewDestinationTypeParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationTypeParams(DataViewDestinationTypeParams)
         */
        default Builder destinationTypeParams(Consumer<DataViewDestinationTypeParams.Builder> destinationTypeParams) {
            return destinationTypeParams(DataViewDestinationTypeParams.builder().applyMutation(destinationTypeParams).build());
        }

        /**
         * <p>
         * The status of a Dataview creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> – Dataview creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> – Dataview creation is starting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Dataview creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – Dataview creation has been cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code> – Dataview creation has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Dataview creation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> – Dataview creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a Dataview creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – Dataview creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> – Dataview creation is starting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Dataview creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – Dataview creation has been cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code> – Dataview creation has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Dataview creation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Dataview creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
         *        </p>
         *        </li>
         * @see DataViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataViewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a Dataview creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> – Dataview creation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code> – Dataview creation is starting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Dataview creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> – Dataview creation has been cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code> – Dataview creation has timed out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Dataview creation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> – Dataview creation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of a Dataview creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – Dataview creation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code> – Dataview creation is starting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Dataview creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> – Dataview creation has been cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code> – Dataview creation has timed out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Dataview creation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Dataview creation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_CLEANUP_FAILED</code> – Dataview creation failed and resource cleanup failed.
         *        </p>
         *        </li>
         * @see DataViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataViewStatus
         */
        Builder status(DataViewStatus status);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private Boolean autoUpdate;

        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();

        private String datasetId;

        private Long asOfTimestamp;

        private DataViewErrorInfo errorInfo;

        private Long lastModifiedTime;

        private Long createTime;

        private List<String> sortColumns = DefaultSdkAutoConstructList.getInstance();

        private String dataViewId;

        private String dataViewArn;

        private DataViewDestinationTypeParams destinationTypeParams;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataViewResponse model) {
            super(model);
            autoUpdate(model.autoUpdate);
            partitionColumns(model.partitionColumns);
            datasetId(model.datasetId);
            asOfTimestamp(model.asOfTimestamp);
            errorInfo(model.errorInfo);
            lastModifiedTime(model.lastModifiedTime);
            createTime(model.createTime);
            sortColumns(model.sortColumns);
            dataViewId(model.dataViewId);
            dataViewArn(model.dataViewArn);
            destinationTypeParams(model.destinationTypeParams);
            status(model.status);
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String... partitionColumns) {
            partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final Long getAsOfTimestamp() {
            return asOfTimestamp;
        }

        public final void setAsOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
        }

        @Override
        public final Builder asOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
            return this;
        }

        public final DataViewErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(DataViewErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(DataViewErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Collection<String> getSortColumns() {
            if (sortColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return sortColumns;
        }

        public final void setSortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(String... sortColumns) {
            sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final String getDataViewId() {
            return dataViewId;
        }

        public final void setDataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
        }

        @Override
        public final Builder dataViewId(String dataViewId) {
            this.dataViewId = dataViewId;
            return this;
        }

        public final String getDataViewArn() {
            return dataViewArn;
        }

        public final void setDataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
        }

        @Override
        public final Builder dataViewArn(String dataViewArn) {
            this.dataViewArn = dataViewArn;
            return this;
        }

        public final DataViewDestinationTypeParams.Builder getDestinationTypeParams() {
            return destinationTypeParams != null ? destinationTypeParams.toBuilder() : null;
        }

        public final void setDestinationTypeParams(DataViewDestinationTypeParams.BuilderImpl destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams != null ? destinationTypeParams.build() : null;
        }

        @Override
        public final Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDataViewResponse build() {
            return new GetDataViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
