/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource permission for a dataset. When you create a dataset, all the other members of the same user group inherit
 * access to the dataset. You can only create a dataset if your user group has application permission for Create
 * Datasets.
 * </p>
 * <p>
 * The following is a list of valid dataset permissions that you can apply:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ViewDatasetDetails</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ReadDatasetDetails</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AddDatasetData</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateDataView</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>EditDatasetMetadata</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteDataset</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information on the dataset permissions, see <a href=
 * "https://docs.aws.amazon.com/finspace/latest/userguide/managing-user-permissions.html#supported-dataset-permissions"
 * >Supported Dataset Permissions</a> in the FinSpace User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePermission implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcePermission.Builder, ResourcePermission> {
    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(ResourcePermission::permission)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String permission;

    private ResourcePermission(BuilderImpl builder) {
        this.permission = builder.permission;
    }

    /**
     * <p>
     * Permission for a resource.
     * </p>
     * 
     * @return Permission for a resource.
     */
    public final String permission() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePermission)) {
            return false;
        }
        ResourcePermission other = (ResourcePermission) obj;
        return Objects.equals(permission(), other.permission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePermission").add("Permission", permission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permission":
            return Optional.ofNullable(clazz.cast(permission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permission", PERMISSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePermission, T> g) {
        return obj -> g.apply((ResourcePermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePermission> {
        /**
         * <p>
         * Permission for a resource.
         * </p>
         * 
         * @param permission
         *        Permission for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permission(String permission);
    }

    static final class BuilderImpl implements Builder {
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePermission model) {
            permission(model.permission);
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public ResourcePermission build() {
            return new ResourcePermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
