/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The request for a CreateDataset operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDatasetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetTitle").getter(getter(CreateDatasetRequest::datasetTitle)).setter(setter(Builder::datasetTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()).build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(CreateDatasetRequest::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(CreateDatasetRequest::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<DatasetOwnerInfo> OWNER_INFO_FIELD = SdkField
            .<DatasetOwnerInfo> builder(MarshallingType.SDK_POJO).memberName("ownerInfo")
            .getter(getter(CreateDatasetRequest::ownerInfo)).setter(setter(Builder::ownerInfo))
            .constructor(DatasetOwnerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerInfo").build()).build();

    private static final SdkField<PermissionGroupParams> PERMISSION_GROUP_PARAMS_FIELD = SdkField
            .<PermissionGroupParams> builder(MarshallingType.SDK_POJO).memberName("permissionGroupParams")
            .getter(getter(CreateDatasetRequest::permissionGroupParams)).setter(setter(Builder::permissionGroupParams))
            .constructor(PermissionGroupParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupParams").build())
            .build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(CreateDatasetRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.<SchemaUnion> builder(MarshallingType.SDK_POJO)
            .memberName("schemaDefinition").getter(getter(CreateDatasetRequest::schemaDefinition))
            .setter(setter(Builder::schemaDefinition)).constructor(SchemaUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, OWNER_INFO_FIELD, PERMISSION_GROUP_PARAMS_FIELD,
            ALIAS_FIELD, SCHEMA_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String datasetTitle;

    private final String kind;

    private final String datasetDescription;

    private final DatasetOwnerInfo ownerInfo;

    private final PermissionGroupParams permissionGroupParams;

    private final String alias;

    private final SchemaUnion schemaDefinition;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.ownerInfo = builder.ownerInfo;
        this.permissionGroupParams = builder.permissionGroupParams;
        this.alias = builder.alias;
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Display title for a FinSpace Dataset.
     * </p>
     * 
     * @return Display title for a FinSpace Dataset.
     */
    public final String datasetTitle() {
        return datasetTitle;
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final DatasetKind kind() {
        return DatasetKind.fromValue(kind);
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * Description of a Dataset.
     * </p>
     * 
     * @return Description of a Dataset.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * Contact information for a Dataset owner.
     * </p>
     * 
     * @return Contact information for a Dataset owner.
     */
    public final DatasetOwnerInfo ownerInfo() {
        return ownerInfo;
    }

    /**
     * <p>
     * Permission group parameters for Dataset permissions.
     * </p>
     * 
     * @return Permission group parameters for Dataset permissions.
     */
    public final PermissionGroupParams permissionGroupParams() {
        return permissionGroupParams;
    }

    /**
     * <p>
     * The unique resource identifier for a Dataset.
     * </p>
     * 
     * @return The unique resource identifier for a Dataset.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Definition for a schema on a tabular Dataset.
     * </p>
     * 
     * @return Definition for a schema on a tabular Dataset.
     */
    public final SchemaUnion schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(permissionGroupParams());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(datasetTitle(), other.datasetTitle())
                && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(ownerInfo(), other.ownerInfo())
                && Objects.equals(permissionGroupParams(), other.permissionGroupParams())
                && Objects.equals(alias(), other.alias()) && Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("ClientToken", clientToken()).add("DatasetTitle", datasetTitle())
                .add("Kind", kindAsString()).add("DatasetDescription", datasetDescription()).add("OwnerInfo", ownerInfo())
                .add("PermissionGroupParams", permissionGroupParams()).add("Alias", alias())
                .add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "datasetTitle":
            return Optional.ofNullable(clazz.cast(datasetTitle()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "ownerInfo":
            return Optional.ofNullable(clazz.cast(ownerInfo()));
        case "permissionGroupParams":
            return Optional.ofNullable(clazz.cast(permissionGroupParams()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("datasetTitle", DATASET_TITLE_FIELD);
        map.put("kind", KIND_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("ownerInfo", OWNER_INFO_FIELD);
        map.put("permissionGroupParams", PERMISSION_GROUP_PARAMS_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("schemaDefinition", SCHEMA_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Display title for a FinSpace Dataset.
         * </p>
         * 
         * @param datasetTitle
         *        Display title for a FinSpace Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTitle(String datasetTitle);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(DatasetKind kind);

        /**
         * <p>
         * Description of a Dataset.
         * </p>
         * 
         * @param datasetDescription
         *        Description of a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * Contact information for a Dataset owner.
         * </p>
         * 
         * @param ownerInfo
         *        Contact information for a Dataset owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInfo(DatasetOwnerInfo ownerInfo);

        /**
         * <p>
         * Contact information for a Dataset owner.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetOwnerInfo.Builder} avoiding the
         * need to create one manually via {@link DatasetOwnerInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetOwnerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #ownerInfo(DatasetOwnerInfo)}.
         * 
         * @param ownerInfo
         *        a consumer that will call methods on {@link DatasetOwnerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerInfo(DatasetOwnerInfo)
         */
        default Builder ownerInfo(Consumer<DatasetOwnerInfo.Builder> ownerInfo) {
            return ownerInfo(DatasetOwnerInfo.builder().applyMutation(ownerInfo).build());
        }

        /**
         * <p>
         * Permission group parameters for Dataset permissions.
         * </p>
         * 
         * @param permissionGroupParams
         *        Permission group parameters for Dataset permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroupParams(PermissionGroupParams permissionGroupParams);

        /**
         * <p>
         * Permission group parameters for Dataset permissions.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionGroupParams.Builder} avoiding
         * the need to create one manually via {@link PermissionGroupParams#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionGroupParams.Builder#build()} is called immediately and
         * its result is passed to {@link #permissionGroupParams(PermissionGroupParams)}.
         * 
         * @param permissionGroupParams
         *        a consumer that will call methods on {@link PermissionGroupParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionGroupParams(PermissionGroupParams)
         */
        default Builder permissionGroupParams(Consumer<PermissionGroupParams.Builder> permissionGroupParams) {
            return permissionGroupParams(PermissionGroupParams.builder().applyMutation(permissionGroupParams).build());
        }

        /**
         * <p>
         * The unique resource identifier for a Dataset.
         * </p>
         * 
         * @param alias
         *        The unique resource identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * 
         * @param schemaDefinition
         *        Definition for a schema on a tabular Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaUnion schemaDefinition);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaUnion.Builder} avoiding the need to
         * create one manually via {@link SchemaUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaDefinition(SchemaUnion)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaUnion)
         */
        default Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return schemaDefinition(SchemaUnion.builder().applyMutation(schemaDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String datasetTitle;

        private String kind;

        private String datasetDescription;

        private DatasetOwnerInfo ownerInfo;

        private PermissionGroupParams permissionGroupParams;

        private String alias;

        private SchemaUnion schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            clientToken(model.clientToken);
            datasetTitle(model.datasetTitle);
            kind(model.kind);
            datasetDescription(model.datasetDescription);
            ownerInfo(model.ownerInfo);
            permissionGroupParams(model.permissionGroupParams);
            alias(model.alias);
            schemaDefinition(model.schemaDefinition);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetTitle() {
            return datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetOwnerInfo.Builder getOwnerInfo() {
            return ownerInfo != null ? ownerInfo.toBuilder() : null;
        }

        public final void setOwnerInfo(DatasetOwnerInfo.BuilderImpl ownerInfo) {
            this.ownerInfo = ownerInfo != null ? ownerInfo.build() : null;
        }

        @Override
        public final Builder ownerInfo(DatasetOwnerInfo ownerInfo) {
            this.ownerInfo = ownerInfo;
            return this;
        }

        public final PermissionGroupParams.Builder getPermissionGroupParams() {
            return permissionGroupParams != null ? permissionGroupParams.toBuilder() : null;
        }

        public final void setPermissionGroupParams(PermissionGroupParams.BuilderImpl permissionGroupParams) {
            this.permissionGroupParams = permissionGroupParams != null ? permissionGroupParams.build() : null;
        }

        @Override
        public final Builder permissionGroupParams(PermissionGroupParams permissionGroupParams) {
            this.permissionGroupParams = permissionGroupParams;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
