/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePermissionGroupRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<CreatePermissionGroupRequest.Builder, CreatePermissionGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreatePermissionGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePermissionGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> APPLICATION_PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicationPermissions")
            .getter(getter(CreatePermissionGroupRequest::applicationPermissionsAsStrings))
            .setter(setter(Builder::applicationPermissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePermissionGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            APPLICATION_PERMISSIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final List<String> applicationPermissions;

    private final String clientToken;

    private CreatePermissionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.applicationPermissions = builder.applicationPermissions;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the permission group.
     * </p>
     * 
     * @return The name of the permission group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A brief description for the permission group.
     * </p>
     * 
     * @return A brief description for the permission group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The option to indicate FinSpace application permissions that are granted to a specific group.
     * </p>
     * <important>
     * <p>
     * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
     * users to grant themselves or others access to any functionality in their FinSpace environment's application. It
     * should only be granted to trusted users.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>CreateDataset</code> – Group members can create new datasets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a privileged
     * permission that allows users to grant themselves or others access to any functionality in the application. It
     * should only be granted to trusted users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ViewAuditData</code> – Group members can view audit data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationPermissions} method.
     * </p>
     * 
     * @return The option to indicate FinSpace application permissions that are granted to a specific group.</p>
     *         <important>
     *         <p>
     *         When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
     *         allows users to grant themselves or others access to any functionality in their FinSpace environment's
     *         application. It should only be granted to trusted users.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateDataset</code> – Group members can create new datasets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
     *         privileged permission that allows users to grant themselves or others access to any functionality in the
     *         application. It should only be granted to trusted users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageAttributeSets</code> – Group members can manage attribute sets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ViewAuditData</code> – Group members can view audit data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
     *         </p>
     *         </li>
     */
    public final List<ApplicationPermission> applicationPermissions() {
        return ApplicationPermissionListCopier.copyStringToEnum(applicationPermissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationPermissions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationPermissions() {
        return applicationPermissions != null && !(applicationPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The option to indicate FinSpace application permissions that are granted to a specific group.
     * </p>
     * <important>
     * <p>
     * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
     * users to grant themselves or others access to any functionality in their FinSpace environment's application. It
     * should only be granted to trusted users.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>CreateDataset</code> – Group members can create new datasets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a privileged
     * permission that allows users to grant themselves or others access to any functionality in the application. It
     * should only be granted to trusted users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ViewAuditData</code> – Group members can view audit data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationPermissions} method.
     * </p>
     * 
     * @return The option to indicate FinSpace application permissions that are granted to a specific group.</p>
     *         <important>
     *         <p>
     *         When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
     *         allows users to grant themselves or others access to any functionality in their FinSpace environment's
     *         application. It should only be granted to trusted users.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateDataset</code> – Group members can create new datasets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
     *         privileged permission that allows users to grant themselves or others access to any functionality in the
     *         application. It should only be granted to trusted users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ManageAttributeSets</code> – Group members can manage attribute sets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ViewAuditData</code> – Group members can view audit data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
     *         </p>
     *         </li>
     */
    public final List<String> applicationPermissionsAsStrings() {
        return applicationPermissions;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationPermissions() ? applicationPermissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePermissionGroupRequest)) {
            return false;
        }
        CreatePermissionGroupRequest other = (CreatePermissionGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasApplicationPermissions() == other.hasApplicationPermissions()
                && Objects.equals(applicationPermissionsAsStrings(), other.applicationPermissionsAsStrings())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePermissionGroupRequest")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApplicationPermissions", hasApplicationPermissions() ? applicationPermissionsAsStrings() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "applicationPermissions":
            return Optional.ofNullable(clazz.cast(applicationPermissionsAsStrings()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("applicationPermissions", APPLICATION_PERMISSIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePermissionGroupRequest, T> g) {
        return obj -> g.apply((CreatePermissionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePermissionGroupRequest> {
        /**
         * <p>
         * The name of the permission group.
         * </p>
         * 
         * @param name
         *        The name of the permission group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A brief description for the permission group.
         * </p>
         * 
         * @param description
         *        A brief description for the permission group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The option to indicate FinSpace application permissions that are granted to a specific group.
         * </p>
         * <important>
         * <p>
         * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
         * users to grant themselves or others access to any functionality in their FinSpace environment's application.
         * It should only be granted to trusted users.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>CreateDataset</code> – Group members can create new datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         * privileged permission that allows users to grant themselves or others access to any functionality in the
         * application. It should only be granted to trusted users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ViewAuditData</code> – Group members can view audit data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationPermissions
         *        The option to indicate FinSpace application permissions that are granted to a specific group.</p>
         *        <important>
         *        <p>
         *        When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
         *        allows users to grant themselves or others access to any functionality in their FinSpace environment's
         *        application. It should only be granted to trusted users.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateDataset</code> – Group members can create new datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         *        privileged permission that allows users to grant themselves or others access to any functionality in
         *        the application. It should only be granted to trusted users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ViewAuditData</code> – Group members can view audit data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissionsWithStrings(Collection<String> applicationPermissions);

        /**
         * <p>
         * The option to indicate FinSpace application permissions that are granted to a specific group.
         * </p>
         * <important>
         * <p>
         * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
         * users to grant themselves or others access to any functionality in their FinSpace environment's application.
         * It should only be granted to trusted users.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>CreateDataset</code> – Group members can create new datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         * privileged permission that allows users to grant themselves or others access to any functionality in the
         * application. It should only be granted to trusted users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ViewAuditData</code> – Group members can view audit data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationPermissions
         *        The option to indicate FinSpace application permissions that are granted to a specific group.</p>
         *        <important>
         *        <p>
         *        When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
         *        allows users to grant themselves or others access to any functionality in their FinSpace environment's
         *        application. It should only be granted to trusted users.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateDataset</code> – Group members can create new datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         *        privileged permission that allows users to grant themselves or others access to any functionality in
         *        the application. It should only be granted to trusted users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ViewAuditData</code> – Group members can view audit data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissionsWithStrings(String... applicationPermissions);

        /**
         * <p>
         * The option to indicate FinSpace application permissions that are granted to a specific group.
         * </p>
         * <important>
         * <p>
         * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
         * users to grant themselves or others access to any functionality in their FinSpace environment's application.
         * It should only be granted to trusted users.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>CreateDataset</code> – Group members can create new datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         * privileged permission that allows users to grant themselves or others access to any functionality in the
         * application. It should only be granted to trusted users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ViewAuditData</code> – Group members can view audit data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationPermissions
         *        The option to indicate FinSpace application permissions that are granted to a specific group.</p>
         *        <important>
         *        <p>
         *        When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
         *        allows users to grant themselves or others access to any functionality in their FinSpace environment's
         *        application. It should only be granted to trusted users.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateDataset</code> – Group members can create new datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         *        privileged permission that allows users to grant themselves or others access to any functionality in
         *        the application. It should only be granted to trusted users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ViewAuditData</code> – Group members can view audit data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissions(Collection<ApplicationPermission> applicationPermissions);

        /**
         * <p>
         * The option to indicate FinSpace application permissions that are granted to a specific group.
         * </p>
         * <important>
         * <p>
         * When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code> allows
         * users to grant themselves or others access to any functionality in their FinSpace environment's application.
         * It should only be granted to trusted users.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>CreateDataset</code> – Group members can create new datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         * privileged permission that allows users to grant themselves or others access to any functionality in the
         * application. It should only be granted to trusted users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ViewAuditData</code> – Group members can view audit data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationPermissions
         *        The option to indicate FinSpace application permissions that are granted to a specific group.</p>
         *        <important>
         *        <p>
         *        When assigning application permissions, be aware that the permission <code>ManageUsersAndGroups</code>
         *        allows users to grant themselves or others access to any functionality in their FinSpace environment's
         *        application. It should only be granted to trusted users.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateDataset</code> – Group members can create new datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageClusters</code> – Group members can manage Apache Spark clusters from FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageUsersAndGroups</code> – Group members can manage users and permission groups. This is a
         *        privileged permission that allows users to grant themselves or others access to any functionality in
         *        the application. It should only be granted to trusted users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ManageAttributeSets</code> – Group members can manage attribute sets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ViewAuditData</code> – Group members can view audit data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessNotebooks</code> – Group members will have access to FinSpace notebooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetTemporaryCredentials</code> – Group members can get temporary API credentials.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPermissions(ApplicationPermission... applicationPermissions);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> applicationPermissions = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePermissionGroupRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            applicationPermissionsWithStrings(model.applicationPermissions);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getApplicationPermissions() {
            if (applicationPermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationPermissions;
        }

        public final void setApplicationPermissions(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
        }

        @Override
        public final Builder applicationPermissionsWithStrings(Collection<String> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copy(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissionsWithStrings(String... applicationPermissions) {
            applicationPermissionsWithStrings(Arrays.asList(applicationPermissions));
            return this;
        }

        @Override
        public final Builder applicationPermissions(Collection<ApplicationPermission> applicationPermissions) {
            this.applicationPermissions = ApplicationPermissionListCopier.copyEnumToString(applicationPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationPermissions(ApplicationPermission... applicationPermissions) {
            applicationPermissions(Arrays.asList(applicationPermissions));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePermissionGroupRequest build() {
            return new CreatePermissionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
