/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response for the GetDataset operation
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatasetResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<GetDatasetResponse.Builder, GetDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(GetDatasetResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(GetDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<String> DATASET_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetTitle").getter(getter(GetDatasetResponse::datasetTitle)).setter(setter(Builder::datasetTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTitle").build()).build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(GetDatasetResponse::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(GetDatasetResponse::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<Long> CREATE_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createTime").getter(getter(GetDatasetResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedTime").getter(getter(GetDatasetResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<SchemaUnion> SCHEMA_DEFINITION_FIELD = SdkField.<SchemaUnion> builder(MarshallingType.SDK_POJO)
            .memberName("schemaDefinition").getter(getter(GetDatasetResponse::schemaDefinition))
            .setter(setter(Builder::schemaDefinition)).constructor(SchemaUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(GetDatasetResponse::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDatasetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_ARN_FIELD, DATASET_TITLE_FIELD, KIND_FIELD, DATASET_DESCRIPTION_FIELD, CREATE_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, SCHEMA_DEFINITION_FIELD, ALIAS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetId;

    private final String datasetArn;

    private final String datasetTitle;

    private final String kind;

    private final String datasetDescription;

    private final Long createTime;

    private final Long lastModifiedTime;

    private final SchemaUnion schemaDefinition;

    private final String alias;

    private final String status;

    private GetDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetTitle = builder.datasetTitle;
        this.kind = builder.kind;
        this.datasetDescription = builder.datasetDescription;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.schemaDefinition = builder.schemaDefinition;
        this.alias = builder.alias;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier for a Dataset.
     * </p>
     * 
     * @return The unique identifier for a Dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The ARN identifier of the Dataset.
     * </p>
     * 
     * @return The ARN identifier of the Dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Display title for a Dataset.
     * </p>
     * 
     * @return Display title for a Dataset.
     */
    public final String datasetTitle() {
        return datasetTitle;
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final DatasetKind kind() {
        return DatasetKind.fromValue(kind);
    }

    /**
     * <p>
     * The format in which Dataset data is structured.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TABULAR</code> – Data is structured in a tabular format.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link DatasetKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The format in which Dataset data is structured.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TABULAR</code> – Data is structured in a tabular format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
     *         </p>
     *         </li>
     * @see DatasetKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * A description of the Dataset.
     * </p>
     * 
     * @return A description of the Dataset.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Long createTime() {
        return createTime;
    }

    /**
     * <p>
     * The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Definition for a schema on a tabular Dataset.
     * </p>
     * 
     * @return Definition for a schema on a tabular Dataset.
     */
    public final SchemaUnion schemaDefinition() {
        return schemaDefinition;
    }

    /**
     * <p>
     * The unique resource identifier for a Dataset.
     * </p>
     * 
     * @return The unique resource identifier for a Dataset.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Status of the Dataset creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – Dataset is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Dataset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Dataset creation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – Dataset creation is running.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Dataset creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Dataset is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Dataset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Dataset creation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – Dataset creation is running.
     *         </p>
     *         </li>
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the Dataset creation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – Dataset is pending creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Dataset creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Dataset creation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code> – Dataset creation is running.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the Dataset creation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Dataset is pending creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Dataset creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Dataset creation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> – Dataset creation is running.
     *         </p>
     *         </li>
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTitle());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatasetResponse)) {
            return false;
        }
        GetDatasetResponse other = (GetDatasetResponse) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(datasetTitle(), other.datasetTitle()) && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(schemaDefinition(), other.schemaDefinition()) && Objects.equals(alias(), other.alias())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatasetResponse").add("DatasetId", datasetId()).add("DatasetArn", datasetArn())
                .add("DatasetTitle", datasetTitle()).add("Kind", kindAsString()).add("DatasetDescription", datasetDescription())
                .add("CreateTime", createTime()).add("LastModifiedTime", lastModifiedTime())
                .add("SchemaDefinition", schemaDefinition()).add("Alias", alias()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "datasetTitle":
            return Optional.ofNullable(clazz.cast(datasetTitle()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetTitle", DATASET_TITLE_FIELD);
        map.put("kind", KIND_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("schemaDefinition", SCHEMA_DEFINITION_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDatasetResponse, T> g) {
        return obj -> g.apply((GetDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDatasetResponse> {
        /**
         * <p>
         * The unique identifier for a Dataset.
         * </p>
         * 
         * @param datasetId
         *        The unique identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The ARN identifier of the Dataset.
         * </p>
         * 
         * @param datasetArn
         *        The ARN identifier of the Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Display title for a Dataset.
         * </p>
         * 
         * @param datasetTitle
         *        Display title for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetTitle(String datasetTitle);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The format in which Dataset data is structured.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TABULAR</code> – Data is structured in a tabular format.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The format in which Dataset data is structured.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TABULAR</code> – Data is structured in a tabular format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_TABULAR</code> – Data is structured in a non-tabular format.
         *        </p>
         *        </li>
         * @see DatasetKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetKind
         */
        Builder kind(DatasetKind kind);

        /**
         * <p>
         * A description of the Dataset.
         * </p>
         * 
         * @param datasetDescription
         *        A description of the Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createTime
         *        The timestamp at which the Dataset was created in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Long createTime);

        /**
         * <p>
         * The last time that the Dataset was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the Dataset was modified. The value is determined as epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * 
         * @param schemaDefinition
         *        Definition for a schema on a tabular Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaUnion schemaDefinition);

        /**
         * <p>
         * Definition for a schema on a tabular Dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaUnion.Builder} avoiding the need to
         * create one manually via {@link SchemaUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #schemaDefinition(SchemaUnion)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaUnion)
         */
        default Builder schemaDefinition(Consumer<SchemaUnion.Builder> schemaDefinition) {
            return schemaDefinition(SchemaUnion.builder().applyMutation(schemaDefinition).build());
        }

        /**
         * <p>
         * The unique resource identifier for a Dataset.
         * </p>
         * 
         * @param alias
         *        The unique resource identifier for a Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Status of the Dataset creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – Dataset is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Dataset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Dataset creation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – Dataset creation is running.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the Dataset creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Dataset is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Dataset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Dataset creation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – Dataset creation is running.
         *        </p>
         *        </li>
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the Dataset creation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – Dataset is pending creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Dataset creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Dataset creation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code> – Dataset creation is running.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status of the Dataset creation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Dataset is pending creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Dataset creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Dataset creation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> – Dataset creation is running.
         *        </p>
         *        </li>
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private String datasetId;

        private String datasetArn;

        private String datasetTitle;

        private String kind;

        private String datasetDescription;

        private Long createTime;

        private Long lastModifiedTime;

        private SchemaUnion schemaDefinition;

        private String alias;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatasetResponse model) {
            super(model);
            datasetId(model.datasetId);
            datasetArn(model.datasetArn);
            datasetTitle(model.datasetTitle);
            kind(model.kind);
            datasetDescription(model.datasetDescription);
            createTime(model.createTime);
            lastModifiedTime(model.lastModifiedTime);
            schemaDefinition(model.schemaDefinition);
            alias(model.alias);
            status(model.status);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetTitle() {
            return datasetTitle;
        }

        public final void setDatasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
        }

        @Override
        public final Builder datasetTitle(String datasetTitle) {
            this.datasetTitle = datasetTitle;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(DatasetKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final Long getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final SchemaUnion.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaUnion.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaUnion schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetDatasetResponse build() {
            return new GetDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
