/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionGroupsResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<ListPermissionGroupsResponse.Builder, ListPermissionGroupsResponse> {
    private static final SdkField<List<PermissionGroup>> PERMISSION_GROUPS_FIELD = SdkField
            .<List<PermissionGroup>> builder(MarshallingType.LIST)
            .memberName("permissionGroups")
            .getter(getter(ListPermissionGroupsResponse::permissionGroups))
            .setter(setter(Builder::permissionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PermissionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PermissionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPermissionGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PermissionGroup> permissionGroups;

    private final String nextToken;

    private ListPermissionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.permissionGroups = builder.permissionGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissionGroups() {
        return permissionGroups != null && !(permissionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the permission groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionGroups} method.
     * </p>
     * 
     * @return A list of all the permission groups.
     */
    public final List<PermissionGroup> permissionGroups() {
        return permissionGroups;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissionGroups() ? permissionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionGroupsResponse)) {
            return false;
        }
        ListPermissionGroupsResponse other = (ListPermissionGroupsResponse) obj;
        return hasPermissionGroups() == other.hasPermissionGroups()
                && Objects.equals(permissionGroups(), other.permissionGroups()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionGroupsResponse")
                .add("PermissionGroups", hasPermissionGroups() ? permissionGroups() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionGroups":
            return Optional.ofNullable(clazz.cast(permissionGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("permissionGroups", PERMISSION_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionGroupsResponse, T> g) {
        return obj -> g.apply((ListPermissionGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPermissionGroupsResponse> {
        /**
         * <p>
         * A list of all the permission groups.
         * </p>
         * 
         * @param permissionGroups
         *        A list of all the permission groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroups(Collection<PermissionGroup> permissionGroups);

        /**
         * <p>
         * A list of all the permission groups.
         * </p>
         * 
         * @param permissionGroups
         *        A list of all the permission groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionGroups(PermissionGroup... permissionGroups);

        /**
         * <p>
         * A list of all the permission groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspacedata.model.PermissionGroup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.finspacedata.model.PermissionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspacedata.model.PermissionGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionGroups(List<PermissionGroup>)}.
         * 
         * @param permissionGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspacedata.model.PermissionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionGroups(java.util.Collection<PermissionGroup>)
         */
        Builder permissionGroups(Consumer<PermissionGroup.Builder>... permissionGroups);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private List<PermissionGroup> permissionGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionGroupsResponse model) {
            super(model);
            permissionGroups(model.permissionGroups);
            nextToken(model.nextToken);
        }

        public final List<PermissionGroup.Builder> getPermissionGroups() {
            List<PermissionGroup.Builder> result = PermissionGroupListCopier.copyToBuilder(this.permissionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissionGroups(Collection<PermissionGroup.BuilderImpl> permissionGroups) {
            this.permissionGroups = PermissionGroupListCopier.copyFromBuilder(permissionGroups);
        }

        @Override
        public final Builder permissionGroups(Collection<PermissionGroup> permissionGroups) {
            this.permissionGroups = PermissionGroupListCopier.copy(permissionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionGroups(PermissionGroup... permissionGroups) {
            permissionGroups(Arrays.asList(permissionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionGroups(Consumer<PermissionGroup.Builder>... permissionGroups) {
            permissionGroups(Stream.of(permissionGroups).map(c -> PermissionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPermissionGroupsResponse build() {
            return new ListPermissionGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
