/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetUserPasswordResponse extends FinspaceDataResponse implements
        ToCopyableBuilder<ResetUserPasswordResponse.Builder, ResetUserPasswordResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ResetUserPasswordResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> TEMPORARY_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("temporaryPassword").getter(getter(ResetUserPasswordResponse::temporaryPassword))
            .setter(setter(Builder::temporaryPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporaryPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            TEMPORARY_PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userId;

    private final String temporaryPassword;

    private ResetUserPasswordResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.temporaryPassword = builder.temporaryPassword;
    }

    /**
     * <p>
     * The unique identifier of the user that a new password is generated for.
     * </p>
     * 
     * @return The unique identifier of the user that a new password is generated for.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * A randomly generated temporary password for the requested user. This password expires in 7 days.
     * </p>
     * 
     * @return A randomly generated temporary password for the requested user. This password expires in 7 days.
     */
    public final String temporaryPassword() {
        return temporaryPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(temporaryPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetUserPasswordResponse)) {
            return false;
        }
        ResetUserPasswordResponse other = (ResetUserPasswordResponse) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(temporaryPassword(), other.temporaryPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetUserPasswordResponse").add("UserId", userId())
                .add("TemporaryPassword", temporaryPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "temporaryPassword":
            return Optional.ofNullable(clazz.cast(temporaryPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userId", USER_ID_FIELD);
        map.put("temporaryPassword", TEMPORARY_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetUserPasswordResponse, T> g) {
        return obj -> g.apply((ResetUserPasswordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FinspaceDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ResetUserPasswordResponse> {
        /**
         * <p>
         * The unique identifier of the user that a new password is generated for.
         * </p>
         * 
         * @param userId
         *        The unique identifier of the user that a new password is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A randomly generated temporary password for the requested user. This password expires in 7 days.
         * </p>
         * 
         * @param temporaryPassword
         *        A randomly generated temporary password for the requested user. This password expires in 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryPassword(String temporaryPassword);
    }

    static final class BuilderImpl extends FinspaceDataResponse.BuilderImpl implements Builder {
        private String userId;

        private String temporaryPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetUserPasswordResponse model) {
            super(model);
            userId(model.userId);
            temporaryPassword(model.temporaryPassword);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getTemporaryPassword() {
            return temporaryPassword;
        }

        public final void setTemporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
        }

        @Override
        public final Builder temporaryPassword(String temporaryPassword) {
            this.temporaryPassword = temporaryPassword;
            return this;
        }

        @Override
        public ResetUserPasswordResponse build() {
            return new ResetUserPasswordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
