/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union of schema types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaUnion implements SdkPojo, Serializable, ToCopyableBuilder<SchemaUnion.Builder, SchemaUnion> {
    private static final SdkField<SchemaDefinition> TABULAR_SCHEMA_CONFIG_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("tabularSchemaConfig")
            .getter(getter(SchemaUnion::tabularSchemaConfig)).setter(setter(Builder::tabularSchemaConfig))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tabularSchemaConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABULAR_SCHEMA_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SchemaDefinition tabularSchemaConfig;

    private SchemaUnion(BuilderImpl builder) {
        this.tabularSchemaConfig = builder.tabularSchemaConfig;
    }

    /**
     * <p>
     * The configuration for a schema on a tabular Dataset.
     * </p>
     * 
     * @return The configuration for a schema on a tabular Dataset.
     */
    public final SchemaDefinition tabularSchemaConfig() {
        return tabularSchemaConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tabularSchemaConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaUnion)) {
            return false;
        }
        SchemaUnion other = (SchemaUnion) obj;
        return Objects.equals(tabularSchemaConfig(), other.tabularSchemaConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaUnion").add("TabularSchemaConfig", tabularSchemaConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tabularSchemaConfig":
            return Optional.ofNullable(clazz.cast(tabularSchemaConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tabularSchemaConfig", TABULAR_SCHEMA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaUnion, T> g) {
        return obj -> g.apply((SchemaUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaUnion> {
        /**
         * <p>
         * The configuration for a schema on a tabular Dataset.
         * </p>
         * 
         * @param tabularSchemaConfig
         *        The configuration for a schema on a tabular Dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tabularSchemaConfig(SchemaDefinition tabularSchemaConfig);

        /**
         * <p>
         * The configuration for a schema on a tabular Dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #tabularSchemaConfig(SchemaDefinition)}.
         * 
         * @param tabularSchemaConfig
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tabularSchemaConfig(SchemaDefinition)
         */
        default Builder tabularSchemaConfig(Consumer<SchemaDefinition.Builder> tabularSchemaConfig) {
            return tabularSchemaConfig(SchemaDefinition.builder().applyMutation(tabularSchemaConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SchemaDefinition tabularSchemaConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaUnion model) {
            tabularSchemaConfig(model.tabularSchemaConfig);
        }

        public final SchemaDefinition.Builder getTabularSchemaConfig() {
            return tabularSchemaConfig != null ? tabularSchemaConfig.toBuilder() : null;
        }

        public final void setTabularSchemaConfig(SchemaDefinition.BuilderImpl tabularSchemaConfig) {
            this.tabularSchemaConfig = tabularSchemaConfig != null ? tabularSchemaConfig.build() : null;
        }

        @Override
        public final Builder tabularSchemaConfig(SchemaDefinition tabularSchemaConfig) {
            this.tabularSchemaConfig = tabularSchemaConfig;
            return this;
        }

        @Override
        public SchemaUnion build() {
            return new SchemaUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
