/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeliveryStreamRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDeliveryStreamRequest.getter(DescribeDeliveryStreamRequest::deliveryStreamName)).setter(DescribeDeliveryStreamRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeDeliveryStreamRequest.getter(DescribeDeliveryStreamRequest::limit)).setter(DescribeDeliveryStreamRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDeliveryStreamRequest.getter(DescribeDeliveryStreamRequest::exclusiveStartDestinationId)).setter(DescribeDeliveryStreamRequest.setter(Builder::exclusiveStartDestinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartDestinationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, LIMIT_FIELD, EXCLUSIVE_START_DESTINATION_ID_FIELD));
    private final String deliveryStreamName;
    private final Integer limit;
    private final String exclusiveStartDestinationId;

    private DescribeDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.limit = builder.limit;
        this.exclusiveStartDestinationId = builder.exclusiveStartDestinationId;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartDestinationId() {
        return this.exclusiveStartDestinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartDestinationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamRequest)) {
            return false;
        }
        DescribeDeliveryStreamRequest other = (DescribeDeliveryStreamRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartDestinationId(), other.exclusiveStartDestinationId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDeliveryStreamRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("Limit", (Object)this.limit()).add("ExclusiveStartDestinationId", (Object)this.exclusiveStartDestinationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "ExclusiveStartDestinationId": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartDestinationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryStreamRequest, T> g) {
        return obj -> g.apply((DescribeDeliveryStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private Integer limit;
        private String exclusiveStartDestinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.limit(model.limit);
            this.exclusiveStartDestinationId(model.exclusiveStartDestinationId);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartDestinationId() {
            return this.exclusiveStartDestinationId;
        }

        @Override
        public final Builder exclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
            return this;
        }

        public final void setExclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeliveryStreamRequest build() {
            return new DescribeDeliveryStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartDestinationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

