/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.HiveJsonSerDe;
import software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deserializer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deserializer> {
    private static final SdkField<OpenXJsonSerDe> OPEN_X_JSON_SER_DE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenXJsonSerDe").getter(Deserializer.getter(Deserializer::openXJsonSerDe)).setter(Deserializer.setter(Builder::openXJsonSerDe)).constructor(OpenXJsonSerDe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenXJsonSerDe").build()}).build();
    private static final SdkField<HiveJsonSerDe> HIVE_JSON_SER_DE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HiveJsonSerDe").getter(Deserializer.getter(Deserializer::hiveJsonSerDe)).setter(Deserializer.setter(Builder::hiveJsonSerDe)).constructor(HiveJsonSerDe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiveJsonSerDe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_X_JSON_SER_DE_FIELD, HIVE_JSON_SER_DE_FIELD));
    private static final long serialVersionUID = 1L;
    private final OpenXJsonSerDe openXJsonSerDe;
    private final HiveJsonSerDe hiveJsonSerDe;

    private Deserializer(BuilderImpl builder) {
        this.openXJsonSerDe = builder.openXJsonSerDe;
        this.hiveJsonSerDe = builder.hiveJsonSerDe;
    }

    public OpenXJsonSerDe openXJsonSerDe() {
        return this.openXJsonSerDe;
    }

    public HiveJsonSerDe hiveJsonSerDe() {
        return this.hiveJsonSerDe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openXJsonSerDe());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiveJsonSerDe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deserializer)) {
            return false;
        }
        Deserializer other = (Deserializer)obj;
        return Objects.equals(this.openXJsonSerDe(), other.openXJsonSerDe()) && Objects.equals(this.hiveJsonSerDe(), other.hiveJsonSerDe());
    }

    public String toString() {
        return ToString.builder((String)"Deserializer").add("OpenXJsonSerDe", (Object)this.openXJsonSerDe()).add("HiveJsonSerDe", (Object)this.hiveJsonSerDe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenXJsonSerDe": {
                return Optional.ofNullable(clazz.cast(this.openXJsonSerDe()));
            }
            case "HiveJsonSerDe": {
                return Optional.ofNullable(clazz.cast(this.hiveJsonSerDe()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deserializer, T> g) {
        return obj -> g.apply((Deserializer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OpenXJsonSerDe openXJsonSerDe;
        private HiveJsonSerDe hiveJsonSerDe;

        private BuilderImpl() {
        }

        private BuilderImpl(Deserializer model) {
            this.openXJsonSerDe(model.openXJsonSerDe);
            this.hiveJsonSerDe(model.hiveJsonSerDe);
        }

        public final OpenXJsonSerDe.Builder getOpenXJsonSerDe() {
            return this.openXJsonSerDe != null ? this.openXJsonSerDe.toBuilder() : null;
        }

        @Override
        public final Builder openXJsonSerDe(OpenXJsonSerDe openXJsonSerDe) {
            this.openXJsonSerDe = openXJsonSerDe;
            return this;
        }

        public final void setOpenXJsonSerDe(OpenXJsonSerDe.BuilderImpl openXJsonSerDe) {
            this.openXJsonSerDe = openXJsonSerDe != null ? openXJsonSerDe.build() : null;
        }

        public final HiveJsonSerDe.Builder getHiveJsonSerDe() {
            return this.hiveJsonSerDe != null ? this.hiveJsonSerDe.toBuilder() : null;
        }

        @Override
        public final Builder hiveJsonSerDe(HiveJsonSerDe hiveJsonSerDe) {
            this.hiveJsonSerDe = hiveJsonSerDe;
            return this;
        }

        public final void setHiveJsonSerDe(HiveJsonSerDe.BuilderImpl hiveJsonSerDe) {
            this.hiveJsonSerDe = hiveJsonSerDe != null ? hiveJsonSerDe.build() : null;
        }

        public Deserializer build() {
            return new Deserializer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deserializer> {
        public Builder openXJsonSerDe(OpenXJsonSerDe var1);

        default public Builder openXJsonSerDe(Consumer<OpenXJsonSerDe.Builder> openXJsonSerDe) {
            return this.openXJsonSerDe((OpenXJsonSerDe)((OpenXJsonSerDe.Builder)OpenXJsonSerDe.builder().applyMutation(openXJsonSerDe)).build());
        }

        public Builder hiveJsonSerDe(HiveJsonSerDe var1);

        default public Builder hiveJsonSerDe(Consumer<HiveJsonSerDe.Builder> hiveJsonSerDe) {
            return this.hiveJsonSerDe((HiveJsonSerDe)((HiveJsonSerDe.Builder)HiveJsonSerDe.builder().applyMutation(hiveJsonSerDe)).build());
        }
    }
}

