/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ListOfNonEmptyStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HiveJsonSerDe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HiveJsonSerDe> {
    private static final SdkField<List<String>> TIMESTAMP_FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimestampFormats").getter(HiveJsonSerDe.getter(HiveJsonSerDe::timestampFormats)).setter(HiveJsonSerDe.setter(Builder::timestampFormats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FORMATS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> timestampFormats;

    private HiveJsonSerDe(BuilderImpl builder) {
        this.timestampFormats = builder.timestampFormats;
    }

    public boolean hasTimestampFormats() {
        return this.timestampFormats != null && !(this.timestampFormats instanceof SdkAutoConstructList);
    }

    public List<String> timestampFormats() {
        return this.timestampFormats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestampFormats() ? this.timestampFormats() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiveJsonSerDe)) {
            return false;
        }
        HiveJsonSerDe other = (HiveJsonSerDe)obj;
        return this.hasTimestampFormats() == other.hasTimestampFormats() && Objects.equals(this.timestampFormats(), other.timestampFormats());
    }

    public String toString() {
        return ToString.builder((String)"HiveJsonSerDe").add("TimestampFormats", this.hasTimestampFormats() ? this.timestampFormats() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimestampFormats": {
                return Optional.ofNullable(clazz.cast(this.timestampFormats()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HiveJsonSerDe, T> g) {
        return obj -> g.apply((HiveJsonSerDe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> timestampFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiveJsonSerDe model) {
            this.timestampFormats(model.timestampFormats);
        }

        public final Collection<String> getTimestampFormats() {
            if (this.timestampFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestampFormats;
        }

        @Override
        public final Builder timestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampFormats(String ... timestampFormats) {
            this.timestampFormats(Arrays.asList(timestampFormats));
            return this;
        }

        public final void setTimestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
        }

        public HiveJsonSerDe build() {
            return new HiveJsonSerDe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HiveJsonSerDe> {
        public Builder timestampFormats(Collection<String> var1);

        public Builder timestampFormats(String ... var1);
    }
}

