/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyType {
    AWS_OWNED_CMK("AWS_OWNED_CMK"),
    CUSTOMER_MANAGED_CMK("CUSTOMER_MANAGED_CMK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyType> knownValues() {
        return Stream.of(KeyType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

