/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonopensearchserviceBufferingHints implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonopensearchserviceBufferingHints.Builder, AmazonopensearchserviceBufferingHints> {
    private static final SdkField<Integer> INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntervalInSeconds").getter(getter(AmazonopensearchserviceBufferingHints::intervalInSeconds))
            .setter(setter(Builder::intervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalInSeconds").build()).build();

    private static final SdkField<Integer> SIZE_IN_M_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMBs").getter(getter(AmazonopensearchserviceBufferingHints::sizeInMBs))
            .setter(setter(Builder::sizeInMBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMBs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_IN_SECONDS_FIELD,
            SIZE_IN_M_BS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer intervalInSeconds;

    private final Integer sizeInMBs;

    private AmazonopensearchserviceBufferingHints(BuilderImpl builder) {
        this.intervalInSeconds = builder.intervalInSeconds;
        this.sizeInMBs = builder.sizeInMBs;
    }

    /**
     * Returns the value of the IntervalInSeconds property for this object.
     * 
     * @return The value of the IntervalInSeconds property for this object.
     */
    public final Integer intervalInSeconds() {
        return intervalInSeconds;
    }

    /**
     * Returns the value of the SizeInMBs property for this object.
     * 
     * @return The value of the SizeInMBs property for this object.
     */
    public final Integer sizeInMBs() {
        return sizeInMBs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMBs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonopensearchserviceBufferingHints)) {
            return false;
        }
        AmazonopensearchserviceBufferingHints other = (AmazonopensearchserviceBufferingHints) obj;
        return Objects.equals(intervalInSeconds(), other.intervalInSeconds()) && Objects.equals(sizeInMBs(), other.sizeInMBs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonopensearchserviceBufferingHints").add("IntervalInSeconds", intervalInSeconds())
                .add("SizeInMBs", sizeInMBs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntervalInSeconds":
            return Optional.ofNullable(clazz.cast(intervalInSeconds()));
        case "SizeInMBs":
            return Optional.ofNullable(clazz.cast(sizeInMBs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonopensearchserviceBufferingHints, T> g) {
        return obj -> g.apply((AmazonopensearchserviceBufferingHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonopensearchserviceBufferingHints> {
        /**
         * Sets the value of the IntervalInSeconds property for this object.
         *
         * @param intervalInSeconds
         *        The new value for the IntervalInSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Integer intervalInSeconds);

        /**
         * Sets the value of the SizeInMBs property for this object.
         *
         * @param sizeInMBs
         *        The new value for the SizeInMBs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMBs(Integer sizeInMBs);
    }

    static final class BuilderImpl implements Builder {
        private Integer intervalInSeconds;

        private Integer sizeInMBs;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonopensearchserviceBufferingHints model) {
            intervalInSeconds(model.intervalInSeconds);
            sizeInMBs(model.sizeInMBs);
        }

        public final Integer getIntervalInSeconds() {
            return intervalInSeconds;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        @Transient
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final Integer getSizeInMBs() {
            return sizeInMBs;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        @Override
        @Transient
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        @Override
        public AmazonopensearchserviceBufferingHints build() {
            return new AmazonopensearchserviceBufferingHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
