/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDeliveryStreamRequest extends FirehoseRequest implements
        ToCopyableBuilder<DeleteDeliveryStreamRequest.Builder, DeleteDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamName").getter(getter(DeleteDeliveryStreamRequest::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build())
            .build();

    private static final SdkField<Boolean> ALLOW_FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowForceDelete").getter(getter(DeleteDeliveryStreamRequest::allowForceDelete))
            .setter(setter(Builder::allowForceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowForceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            ALLOW_FORCE_DELETE_FIELD));

    private final String deliveryStreamName;

    private final Boolean allowForceDelete;

    private DeleteDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.allowForceDelete = builder.allowForceDelete;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the
     * grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as
     * when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to
     * revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS
     * issue, Kinesis Data Firehose keeps retrying the delete operation.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to
     *         retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer
     *         error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use
     *         the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a>
     *         operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens
     *         due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p>
     *         <p>
     *         The default value is false.
     */
    public final Boolean allowForceDelete() {
        return allowForceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(allowForceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeliveryStreamRequest)) {
            return false;
        }
        DeleteDeliveryStreamRequest other = (DeleteDeliveryStreamRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(allowForceDelete(), other.allowForceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDeliveryStreamRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("AllowForceDelete", allowForceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "AllowForceDelete":
            return Optional.ofNullable(clazz.cast(allowForceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDeliveryStreamRequest, T> g) {
        return obj -> g.apply((DeleteDeliveryStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire
         * the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error,
         * such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to
         * revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS
         * KMS issue, Kinesis Data Firehose keeps retrying the delete operation.
         * </p>
         * <p>
         * The default value is false.
         * </p>
         * 
         * @param allowForceDelete
         *        Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to
         *        retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a
         *        customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you
         *        can then use the <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a>
         *        operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant
         *        happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p>
         *        <p>
         *        The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowForceDelete(Boolean allowForceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private Boolean allowForceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeliveryStreamRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            allowForceDelete(model.allowForceDelete);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        @Transient
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final Boolean getAllowForceDelete() {
            return allowForceDelete;
        }

        public final void setAllowForceDelete(Boolean allowForceDelete) {
            this.allowForceDelete = allowForceDelete;
        }

        @Override
        @Transient
        public final Builder allowForceDelete(Boolean allowForceDelete) {
            this.allowForceDelete = allowForceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDeliveryStreamRequest build() {
            return new DeleteDeliveryStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
