/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the server-side encryption (SSE) status for the delivery stream, the type customer master
 * key (CMK) in use, if any, and the ARN of the CMK. You can get <code>DeliveryStreamEncryptionConfiguration</code> by
 * invoking the <a>DescribeDeliveryStream</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryStreamEncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliveryStreamEncryptionConfiguration.Builder, DeliveryStreamEncryptionConfiguration> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyARN")
            .getter(getter(DeliveryStreamEncryptionConfiguration::keyARN)).setter(setter(Builder::keyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyARN").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyType").getter(getter(DeliveryStreamEncryptionConfiguration::keyTypeAsString))
            .setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeliveryStreamEncryptionConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<FailureDescription> FAILURE_DESCRIPTION_FIELD = SdkField
            .<FailureDescription> builder(MarshallingType.SDK_POJO).memberName("FailureDescription")
            .getter(getter(DeliveryStreamEncryptionConfiguration::failureDescription))
            .setter(setter(Builder::failureDescription)).constructor(FailureDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD,
            STATUS_FIELD, FAILURE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyARN;

    private final String keyType;

    private final String status;

    private final FailureDescription failureDescription;

    private DeliveryStreamEncryptionConfiguration(BuilderImpl builder) {
        this.keyARN = builder.keyARN;
        this.keyType = builder.keyType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
    }

    /**
     * <p>
     * If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the ARN of the customer managed
     * CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>, <code>DeliveryStreamEncryptionConfiguration</code>
     * doesn't contain a value for <code>KeyARN</code>.
     * </p>
     * 
     * @return If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the ARN of the customer
     *         managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
     *         <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for <code>KeyARN</code>.
     */
    public final String keyARN() {
        return keyARN;
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
     * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
     *         <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>.
     * @see KeyType
     */
    public final KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
     * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
     *         <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>.
     * @see KeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    /**
     * <p>
     * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the different
     * values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this
     * status is <code>ENABLING_FAILED</code> or <code>DISABLING_FAILED</code>, it is the status of the most recent
     * attempt to enable or disable SSE, respectively.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeliveryStreamEncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
     *         different values of this status, see <a>StartDeliveryStreamEncryption</a> and
     *         <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
     *         <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
     *         respectively.
     * @see DeliveryStreamEncryptionStatus
     */
    public final DeliveryStreamEncryptionStatus status() {
        return DeliveryStreamEncryptionStatus.fromValue(status);
    }

    /**
     * <p>
     * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the different
     * values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this
     * status is <code>ENABLING_FAILED</code> or <code>DISABLING_FAILED</code>, it is the status of the most recent
     * attempt to enable or disable SSE, respectively.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeliveryStreamEncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
     *         different values of this status, see <a>StartDeliveryStreamEncryption</a> and
     *         <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
     *         <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
     *         respectively.
     * @see DeliveryStreamEncryptionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides details in case one of the following operations fails due to an error related to KMS:
     * <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
     * <a>StopDeliveryStreamEncryption</a>.
     * </p>
     * 
     * @return Provides details in case one of the following operations fails due to an error related to KMS:
     *         <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
     *         <a>StopDeliveryStreamEncryption</a>.
     */
    public final FailureDescription failureDescription() {
        return failureDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyARN());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfiguration)) {
            return false;
        }
        DeliveryStreamEncryptionConfiguration other = (DeliveryStreamEncryptionConfiguration) obj;
        return Objects.equals(keyARN(), other.keyARN()) && Objects.equals(keyTypeAsString(), other.keyTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureDescription(), other.failureDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliveryStreamEncryptionConfiguration").add("KeyARN", keyARN())
                .add("KeyType", keyTypeAsString()).add("Status", statusAsString())
                .add("FailureDescription", failureDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyARN":
            return Optional.ofNullable(clazz.cast(keyARN()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureDescription":
            return Optional.ofNullable(clazz.cast(failureDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamEncryptionConfiguration, T> g) {
        return obj -> g.apply((DeliveryStreamEncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryStreamEncryptionConfiguration> {
        /**
         * <p>
         * If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the ARN of the customer
         * managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
         * <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for <code>KeyARN</code>.
         * </p>
         * 
         * @param keyARN
         *        If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the ARN of the
         *        customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>,
         *        <code>DeliveryStreamEncryptionConfiguration</code> doesn't contain a value for <code>KeyARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyARN(String keyARN);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
         * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>.
         * </p>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
         *        <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
         * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>.
         * </p>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) that is used for encryption. The default setting is
         *        <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);

        /**
         * <p>
         * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
         * different values of this status, see <a>StartDeliveryStreamEncryption</a> and
         * <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
         * <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
         * respectively.
         * </p>
         * 
         * @param status
         *        This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
         *        different values of this status, see <a>StartDeliveryStreamEncryption</a> and
         *        <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
         *        <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
         *        respectively.
         * @see DeliveryStreamEncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamEncryptionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
         * different values of this status, see <a>StartDeliveryStreamEncryption</a> and
         * <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
         * <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
         * respectively.
         * </p>
         * 
         * @param status
         *        This is the server-side encryption (SSE) status for the delivery stream. For a full description of the
         *        different values of this status, see <a>StartDeliveryStreamEncryption</a> and
         *        <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or
         *        <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE,
         *        respectively.
         * @see DeliveryStreamEncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamEncryptionStatus
         */
        Builder status(DeliveryStreamEncryptionStatus status);

        /**
         * <p>
         * Provides details in case one of the following operations fails due to an error related to KMS:
         * <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
         * <a>StopDeliveryStreamEncryption</a>.
         * </p>
         * 
         * @param failureDescription
         *        Provides details in case one of the following operations fails due to an error related to KMS:
         *        <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
         *        <a>StopDeliveryStreamEncryption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDescription(FailureDescription failureDescription);

        /**
         * <p>
         * Provides details in case one of the following operations fails due to an error related to KMS:
         * <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
         * <a>StopDeliveryStreamEncryption</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link FailureDescription.Builder} avoiding the need to
         * create one manually via {@link FailureDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailureDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #failureDescription(FailureDescription)}.
         * 
         * @param failureDescription
         *        a consumer that will call methods on {@link FailureDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDescription(FailureDescription)
         */
        default Builder failureDescription(Consumer<FailureDescription.Builder> failureDescription) {
            return failureDescription(FailureDescription.builder().applyMutation(failureDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String keyARN;

        private String keyType;

        private String status;

        private FailureDescription failureDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamEncryptionConfiguration model) {
            keyARN(model.keyARN);
            keyType(model.keyType);
            status(model.status);
            failureDescription(model.failureDescription);
        }

        public final String getKeyARN() {
            return keyARN;
        }

        public final void setKeyARN(String keyARN) {
            this.keyARN = keyARN;
        }

        @Override
        @Transient
        public final Builder keyARN(String keyARN) {
            this.keyARN = keyARN;
            return this;
        }

        public final String getKeyType() {
            return keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        @Transient
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        @Transient
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DeliveryStreamEncryptionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final FailureDescription.Builder getFailureDescription() {
            return failureDescription != null ? failureDescription.toBuilder() : null;
        }

        public final void setFailureDescription(FailureDescription.BuilderImpl failureDescription) {
            this.failureDescription = failureDescription != null ? failureDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder failureDescription(FailureDescription failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        @Override
        public DeliveryStreamEncryptionConfiguration build() {
            return new DeliveryStreamEncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
