/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the dynamic partitioning mechanism that creates smaller data sets from the streaming data by
 * partitioning it based on partition keys. Currently, dynamic partitioning is only supported for Amazon S3
 * destinations. For more information, see <a
 * href="https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html"
 * >https://docs.aws.amazon.com/firehose/latest/dev/dynamic-partitioning.html</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicPartitioningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicPartitioningConfiguration.Builder, DynamicPartitioningConfiguration> {
    private static final SdkField<RetryOptions> RETRY_OPTIONS_FIELD = SdkField.<RetryOptions> builder(MarshallingType.SDK_POJO)
            .memberName("RetryOptions").getter(getter(DynamicPartitioningConfiguration::retryOptions))
            .setter(setter(Builder::retryOptions)).constructor(RetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(DynamicPartitioningConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_OPTIONS_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final RetryOptions retryOptions;

    private final Boolean enabled;

    private DynamicPartitioningConfiguration(BuilderImpl builder) {
        this.retryOptions = builder.retryOptions;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
     * </p>
     * 
     * @return The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
     */
    public final RetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @return Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicPartitioningConfiguration)) {
            return false;
        }
        DynamicPartitioningConfiguration other = (DynamicPartitioningConfiguration) obj;
        return Objects.equals(retryOptions(), other.retryOptions()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicPartitioningConfiguration").add("RetryOptions", retryOptions()).add("Enabled", enabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicPartitioningConfiguration, T> g) {
        return obj -> g.apply((DynamicPartitioningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicPartitioningConfiguration> {
        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(RetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryOptions.Builder} avoiding the need to
         * create one manually via {@link RetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #retryOptions(RetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link RetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(RetryOptions)
         */
        default Builder retryOptions(Consumer<RetryOptions.Builder> retryOptions) {
            return retryOptions(RetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
         * </p>
         * 
         * @param enabled
         *        Specifies that the dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private RetryOptions retryOptions;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicPartitioningConfiguration model) {
            retryOptions(model.retryOptions);
            enabled(model.enabled);
        }

        public final RetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(RetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public DynamicPartitioningConfiguration build() {
            return new DynamicPartitioningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
