/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordResponse extends FirehoseResponse implements
        ToCopyableBuilder<PutRecordResponse.Builder, PutRecordResponse> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(PutRecordResponse::recordId)).setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(PutRecordResponse::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD,
            ENCRYPTED_FIELD));

    private final String recordId;

    private final Boolean encrypted;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.recordId = builder.recordId;
        this.encrypted = builder.encrypted;
    }

    /**
     * <p>
     * The ID of the record.
     * </p>
     * 
     * @return The ID of the record.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * <p>
     * Indicates whether server-side encryption (SSE) was enabled during this operation.
     * </p>
     * 
     * @return Indicates whether server-side encryption (SSE) was enabled during this operation.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse) obj;
        return Objects.equals(recordId(), other.recordId()) && Objects.equals(encrypted(), other.encrypted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordResponse").add("RecordId", recordId()).add("Encrypted", encrypted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordResponse, T> g) {
        return obj -> g.apply((PutRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRecordResponse> {
        /**
         * <p>
         * The ID of the record.
         * </p>
         * 
         * @param recordId
         *        The ID of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * Indicates whether server-side encryption (SSE) was enabled during this operation.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether server-side encryption (SSE) was enabled during this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private String recordId;

        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            super(model);
            recordId(model.recordId);
            encrypted(model.encrypted);
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        @Transient
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
