/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Processor implements SdkPojo, Serializable, ToCopyableBuilder<Processor.Builder, Processor> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Processor::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<ProcessorParameter>> PARAMETERS_FIELD = SdkField
            .<List<ProcessorParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(Processor::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessorParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessorParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<ProcessorParameter> parameters;

    private Processor(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The type of processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProcessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of processor.
     * @see ProcessorType
     */
    public final ProcessorType type() {
        return ProcessorType.fromValue(type);
    }

    /**
     * <p>
     * The type of processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProcessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of processor.
     * @see ProcessorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The processor parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The processor parameters.
     */
    public final List<ProcessorParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Processor").add("Type", typeAsString()).add("Parameters", hasParameters() ? parameters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Processor, T> g) {
        return obj -> g.apply((Processor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Processor> {
        /**
         * <p>
         * The type of processor.
         * </p>
         * 
         * @param type
         *        The type of processor.
         * @see ProcessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of processor.
         * </p>
         * 
         * @param type
         *        The type of processor.
         * @see ProcessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorType
         */
        Builder type(ProcessorType type);

        /**
         * <p>
         * The processor parameters.
         * </p>
         * 
         * @param parameters
         *        The processor parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ProcessorParameter> parameters);

        /**
         * <p>
         * The processor parameters.
         * </p>
         * 
         * @param parameters
         *        The processor parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ProcessorParameter... parameters);

        /**
         * <p>
         * The processor parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProcessorParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ProcessorParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessorParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<ProcessorParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<ProcessorParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<ProcessorParameter>)
         */
        Builder parameters(Consumer<ProcessorParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<ProcessorParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            type(model.type);
            parameters(model.parameters);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProcessorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<ProcessorParameter.Builder> getParameters() {
            List<ProcessorParameter.Builder> result = ProcessorParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ProcessorParameter.BuilderImpl> parameters) {
            this.parameters = ProcessorParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ProcessorParameter> parameters) {
            this.parameters = ProcessorParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ProcessorParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ProcessorParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ProcessorParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Processor build() {
            return new Processor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
