/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonopensearchserviceDestinationConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AmazonopensearchserviceDestinationConfiguration.Builder, AmazonopensearchserviceDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(AmazonopensearchserviceDestinationConfiguration::roleARN))
            .setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainARN").getter(getter(AmazonopensearchserviceDestinationConfiguration::domainARN))
            .setter(setter(Builder::domainARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()).build();

    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterEndpoint").getter(getter(AmazonopensearchserviceDestinationConfiguration::clusterEndpoint))
            .setter(setter(Builder::clusterEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(AmazonopensearchserviceDestinationConfiguration::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(AmazonopensearchserviceDestinationConfiguration::typeName))
            .setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexRotationPeriod")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::indexRotationPeriodAsString))
            .setter(setter(Builder::indexRotationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build())
            .build();

    private static final SdkField<AmazonopensearchserviceBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<AmazonopensearchserviceBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::bufferingHints))
            .setter(setter(Builder::bufferingHints)).constructor(AmazonopensearchserviceBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<AmazonopensearchserviceRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<AmazonopensearchserviceRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::retryOptions)).setter(setter(Builder::retryOptions))
            .constructor(AmazonopensearchserviceRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(AmazonopensearchserviceDestinationConfiguration::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::s3Configuration))
            .setter(setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(AmazonopensearchserviceDestinationConfiguration::vpcConfiguration))
            .setter(setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD,
            BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD,
            PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String domainARN;

    private final String clusterEndpoint;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final AmazonopensearchserviceBufferingHints bufferingHints;

    private final AmazonopensearchserviceRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationConfiguration s3Configuration;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final VpcConfiguration vpcConfiguration;

    private AmazonopensearchserviceDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * Returns the value of the RoleARN property for this object.
     * 
     * @return The value of the RoleARN property for this object.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * Returns the value of the DomainARN property for this object.
     * 
     * @return The value of the DomainARN property for this object.
     */
    public final String domainARN() {
        return domainARN;
    }

    /**
     * Returns the value of the ClusterEndpoint property for this object.
     * 
     * @return The value of the ClusterEndpoint property for this object.
     */
    public final String clusterEndpoint() {
        return clusterEndpoint;
    }

    /**
     * Returns the value of the IndexName property for this object.
     * 
     * @return The value of the IndexName property for this object.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * Returns the value of the TypeName property for this object.
     * 
     * @return The value of the TypeName property for this object.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * Returns the value of the IndexRotationPeriod property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return
     * {@link AmazonopensearchserviceIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The value of the IndexRotationPeriod property for this object.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */
    public final AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod() {
        return AmazonopensearchserviceIndexRotationPeriod.fromValue(indexRotationPeriod);
    }

    /**
     * Returns the value of the IndexRotationPeriod property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return
     * {@link AmazonopensearchserviceIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The value of the IndexRotationPeriod property for this object.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */
    public final String indexRotationPeriodAsString() {
        return indexRotationPeriod;
    }

    /**
     * Returns the value of the BufferingHints property for this object.
     * 
     * @return The value of the BufferingHints property for this object.
     */
    public final AmazonopensearchserviceBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * Returns the value of the RetryOptions property for this object.
     * 
     * @return The value of the RetryOptions property for this object.
     */
    public final AmazonopensearchserviceRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * Returns the value of the S3BackupMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link AmazonopensearchserviceS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The value of the S3BackupMode property for this object.
     * @see AmazonopensearchserviceS3BackupMode
     */
    public final AmazonopensearchserviceS3BackupMode s3BackupMode() {
        return AmazonopensearchserviceS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * Returns the value of the S3BackupMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link AmazonopensearchserviceS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The value of the S3BackupMode property for this object.
     * @see AmazonopensearchserviceS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * Returns the value of the S3Configuration property for this object.
     * 
     * @return The value of the S3Configuration property for this object.
     */
    public final S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * Returns the value of the ProcessingConfiguration property for this object.
     * 
     * @return The value of the ProcessingConfiguration property for this object.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * Returns the value of the CloudWatchLoggingOptions property for this object.
     * 
     * @return The value of the CloudWatchLoggingOptions property for this object.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * Returns the value of the VpcConfiguration property for this object.
     * 
     * @return The value of the VpcConfiguration property for this object.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonopensearchserviceDestinationConfiguration)) {
            return false;
        }
        AmazonopensearchserviceDestinationConfiguration other = (AmazonopensearchserviceDestinationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(domainARN(), other.domainARN())
                && Objects.equals(clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(typeName(), other.typeName())
                && Objects.equals(indexRotationPeriodAsString(), other.indexRotationPeriodAsString())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonopensearchserviceDestinationConfiguration").add("RoleARN", roleARN())
                .add("DomainARN", domainARN()).add("ClusterEndpoint", clusterEndpoint()).add("IndexName", indexName())
                .add("TypeName", typeName()).add("IndexRotationPeriod", indexRotationPeriodAsString())
                .add("BufferingHints", bufferingHints()).add("RetryOptions", retryOptions())
                .add("S3BackupMode", s3BackupModeAsString()).add("S3Configuration", s3Configuration())
                .add("ProcessingConfiguration", processingConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "DomainARN":
            return Optional.ofNullable(clazz.cast(domainARN()));
        case "ClusterEndpoint":
            return Optional.ofNullable(clazz.cast(clusterEndpoint()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "IndexRotationPeriod":
            return Optional.ofNullable(clazz.cast(indexRotationPeriodAsString()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonopensearchserviceDestinationConfiguration, T> g) {
        return obj -> g.apply((AmazonopensearchserviceDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonopensearchserviceDestinationConfiguration> {
        /**
         * Sets the value of the RoleARN property for this object.
         *
         * @param roleARN
         *        The new value for the RoleARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * Sets the value of the DomainARN property for this object.
         *
         * @param domainARN
         *        The new value for the DomainARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * Sets the value of the ClusterEndpoint property for this object.
         *
         * @param clusterEndpoint
         *        The new value for the ClusterEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoint(String clusterEndpoint);

        /**
         * Sets the value of the IndexName property for this object.
         *
         * @param indexName
         *        The new value for the IndexName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * Sets the value of the TypeName property for this object.
         *
         * @param typeName
         *        The new value for the TypeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * Sets the value of the IndexRotationPeriod property for this object.
         *
         * @param indexRotationPeriod
         *        The new value for the IndexRotationPeriod property for this object.
         * @see AmazonopensearchserviceIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonopensearchserviceIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * Sets the value of the IndexRotationPeriod property for this object.
         *
         * @param indexRotationPeriod
         *        The new value for the IndexRotationPeriod property for this object.
         * @see AmazonopensearchserviceIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonopensearchserviceIndexRotationPeriod
         */
        Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod);

        /**
         * Sets the value of the BufferingHints property for this object.
         *
         * @param bufferingHints
         *        The new value for the BufferingHints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(AmazonopensearchserviceBufferingHints bufferingHints);

        /**
         * Sets the value of the BufferingHints property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AmazonopensearchserviceBufferingHints.Builder} avoiding the need to create one manually via
         * {@link AmazonopensearchserviceBufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonopensearchserviceBufferingHints.Builder#build()} is called
         * immediately and its result is passed to {@link #bufferingHints(AmazonopensearchserviceBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link AmazonopensearchserviceBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(AmazonopensearchserviceBufferingHints)
         */
        default Builder bufferingHints(Consumer<AmazonopensearchserviceBufferingHints.Builder> bufferingHints) {
            return bufferingHints(AmazonopensearchserviceBufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * Sets the value of the RetryOptions property for this object.
         *
         * @param retryOptions
         *        The new value for the RetryOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(AmazonopensearchserviceRetryOptions retryOptions);

        /**
         * Sets the value of the RetryOptions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AmazonopensearchserviceRetryOptions.Builder} avoiding the need to create one manually via
         * {@link AmazonopensearchserviceRetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonopensearchserviceRetryOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #retryOptions(AmazonopensearchserviceRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link AmazonopensearchserviceRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(AmazonopensearchserviceRetryOptions)
         */
        default Builder retryOptions(Consumer<AmazonopensearchserviceRetryOptions.Builder> retryOptions) {
            return retryOptions(AmazonopensearchserviceRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * Sets the value of the S3BackupMode property for this object.
         *
         * @param s3BackupMode
         *        The new value for the S3BackupMode property for this object.
         * @see AmazonopensearchserviceS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonopensearchserviceS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * Sets the value of the S3BackupMode property for this object.
         *
         * @param s3BackupMode
         *        The new value for the S3BackupMode property for this object.
         * @see AmazonopensearchserviceS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmazonopensearchserviceS3BackupMode
         */
        Builder s3BackupMode(AmazonopensearchserviceS3BackupMode s3BackupMode);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * @param s3Configuration
         *        The new value for the S3Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DestinationConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DestinationConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DestinationConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * @param processingConfiguration
         *        The new value for the ProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * @param cloudWatchLoggingOptions
         *        The new value for the CloudWatchLoggingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * @param vpcConfiguration
         *        The new value for the VpcConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * Sets the value of the VpcConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String clusterEndpoint;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private AmazonopensearchserviceBufferingHints bufferingHints;

        private AmazonopensearchserviceRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationConfiguration s3Configuration;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonopensearchserviceDestinationConfiguration model) {
            roleARN(model.roleARN);
            domainARN(model.domainARN);
            clusterEndpoint(model.clusterEndpoint);
            indexName(model.indexName);
            typeName(model.typeName);
            indexRotationPeriod(model.indexRotationPeriod);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Configuration(model.s3Configuration);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final AmazonopensearchserviceBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonopensearchserviceBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonopensearchserviceBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonopensearchserviceRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonopensearchserviceRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonopensearchserviceRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(AmazonopensearchserviceS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public AmazonopensearchserviceDestinationConfiguration build() {
            return new AmazonopensearchserviceDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
