/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeliveryStreamRequest extends FirehoseRequest implements
        ToCopyableBuilder<DescribeDeliveryStreamRequest.Builder, DescribeDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamName").getter(getter(DescribeDeliveryStreamRequest::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeDeliveryStreamRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_DESTINATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartDestinationId")
            .getter(getter(DescribeDeliveryStreamRequest::exclusiveStartDestinationId))
            .setter(setter(Builder::exclusiveStartDestinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartDestinationId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            LIMIT_FIELD, EXCLUSIVE_START_DESTINATION_ID_FIELD));

    private final String deliveryStreamName;

    private final Integer limit;

    private final String exclusiveStartDestinationId;

    private DescribeDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.limit = builder.limit;
        this.exclusiveStartDestinationId = builder.exclusiveStartDestinationId;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The limit on the number of destinations to return. You can have one destination per delivery stream.
     * </p>
     * 
     * @return The limit on the number of destinations to return. You can have one destination per delivery stream.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one
     * destination per delivery stream.
     * </p>
     * 
     * @return The ID of the destination to start returning the destination information. Kinesis Data Firehose supports
     *         one destination per delivery stream.
     */
    public final String exclusiveStartDestinationId() {
        return exclusiveStartDestinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartDestinationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamRequest)) {
            return false;
        }
        DescribeDeliveryStreamRequest other = (DescribeDeliveryStreamRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartDestinationId(), other.exclusiveStartDestinationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeliveryStreamRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("Limit", limit()).add("ExclusiveStartDestinationId", exclusiveStartDestinationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "ExclusiveStartDestinationId":
            return Optional.ofNullable(clazz.cast(exclusiveStartDestinationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryStreamRequest, T> g) {
        return obj -> g.apply((DescribeDeliveryStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The limit on the number of destinations to return. You can have one destination per delivery stream.
         * </p>
         * 
         * @param limit
         *        The limit on the number of destinations to return. You can have one destination per delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one
         * destination per delivery stream.
         * </p>
         * 
         * @param exclusiveStartDestinationId
         *        The ID of the destination to start returning the destination information. Kinesis Data Firehose
         *        supports one destination per delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartDestinationId(String exclusiveStartDestinationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private Integer limit;

        private String exclusiveStartDestinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            limit(model.limit);
            exclusiveStartDestinationId(model.exclusiveStartDestinationId);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getExclusiveStartDestinationId() {
            return exclusiveStartDestinationId;
        }

        public final void setExclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
        }

        @Override
        public final Builder exclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeliveryStreamRequest build() {
            return new DescribeDeliveryStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
