/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes hints for the buffering to perform before delivering data to the destination. These options are treated as
 * hints, and therefore Kinesis Data Firehose might choose to use different values when it is optimal. The
 * <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for
 * one of them, you must also provide a value for the other.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BufferingHints implements SdkPojo, Serializable, ToCopyableBuilder<BufferingHints.Builder, BufferingHints> {
    private static final SdkField<Integer> SIZE_IN_M_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMBs").getter(getter(BufferingHints::sizeInMBs)).setter(setter(Builder::sizeInMBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMBs").build()).build();

    private static final SdkField<Integer> INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntervalInSeconds").getter(getter(BufferingHints::intervalInSeconds))
            .setter(setter(Builder::intervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_M_BS_FIELD,
            INTERVAL_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeInMBs;

    private final Integer intervalInSeconds;

    private BufferingHints(BuilderImpl builder) {
        this.sizeInMBs = builder.sizeInMBs;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    /**
     * <p>
     * Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default value
     * is 5. This parameter is optional but if you specify a value for it, you must also specify a value for
     * <code>IntervalInSeconds</code>, and vice versa.
     * </p>
     * <p>
     * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the
     * delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value should be 10 MiB
     * or higher.
     * </p>
     * 
     * @return Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default
     *         value is 5. This parameter is optional but if you specify a value for it, you must also specify a value
     *         for <code>IntervalInSeconds</code>, and vice versa.</p>
     *         <p>
     *         We recommend setting this parameter to a value greater than the amount of data you typically ingest into
     *         the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value
     *         should be 10 MiB or higher.
     */
    public final Integer sizeInMBs() {
        return sizeInMBs;
    }

    /**
     * <p>
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The
     * default value is 300. This parameter is optional but if you specify a value for it, you must also specify a value
     * for <code>SizeInMBs</code>, and vice versa.
     * </p>
     * 
     * @return Buffer incoming data for the specified period of time, in seconds, before delivering it to the
     *         destination. The default value is 300. This parameter is optional but if you specify a value for it, you
     *         must also specify a value for <code>SizeInMBs</code>, and vice versa.
     */
    public final Integer intervalInSeconds() {
        return intervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMBs());
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BufferingHints)) {
            return false;
        }
        BufferingHints other = (BufferingHints) obj;
        return Objects.equals(sizeInMBs(), other.sizeInMBs()) && Objects.equals(intervalInSeconds(), other.intervalInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BufferingHints").add("SizeInMBs", sizeInMBs()).add("IntervalInSeconds", intervalInSeconds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInMBs":
            return Optional.ofNullable(clazz.cast(sizeInMBs()));
        case "IntervalInSeconds":
            return Optional.ofNullable(clazz.cast(intervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BufferingHints, T> g) {
        return obj -> g.apply((BufferingHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BufferingHints> {
        /**
         * <p>
         * Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default
         * value is 5. This parameter is optional but if you specify a value for it, you must also specify a value for
         * <code>IntervalInSeconds</code>, and vice versa.
         * </p>
         * <p>
         * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the
         * delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value should be 10
         * MiB or higher.
         * </p>
         * 
         * @param sizeInMBs
         *        Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The
         *        default value is 5. This parameter is optional but if you specify a value for it, you must also
         *        specify a value for <code>IntervalInSeconds</code>, and vice versa.</p>
         *        <p>
         *        We recommend setting this parameter to a value greater than the amount of data you typically ingest
         *        into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the
         *        value should be 10 MiB or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMBs(Integer sizeInMBs);

        /**
         * <p>
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * The default value is 300. This parameter is optional but if you specify a value for it, you must also specify
         * a value for <code>SizeInMBs</code>, and vice versa.
         * </p>
         * 
         * @param intervalInSeconds
         *        Buffer incoming data for the specified period of time, in seconds, before delivering it to the
         *        destination. The default value is 300. This parameter is optional but if you specify a value for it,
         *        you must also specify a value for <code>SizeInMBs</code>, and vice versa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Integer intervalInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMBs;

        private Integer intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BufferingHints model) {
            sizeInMBs(model.sizeInMBs);
            intervalInSeconds(model.intervalInSeconds);
        }

        public final Integer getSizeInMBs() {
            return sizeInMBs;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        @Override
        @Transient
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final Integer getIntervalInSeconds() {
            return intervalInSeconds;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        @Transient
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        @Override
        public BufferingHints build() {
            return new BufferingHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
