/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a <code>COPY</code> command for Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyCommand implements SdkPojo, Serializable, ToCopyableBuilder<CopyCommand.Builder, CopyCommand> {
    private static final SdkField<String> DATA_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableName").getter(getter(CopyCommand::dataTableName)).setter(setter(Builder::dataTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableName").build()).build();

    private static final SdkField<String> DATA_TABLE_COLUMNS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableColumns").getter(getter(CopyCommand::dataTableColumns))
            .setter(setter(Builder::dataTableColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableColumns").build()).build();

    private static final SdkField<String> COPY_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyOptions").getter(getter(CopyCommand::copyOptions)).setter(setter(Builder::copyOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLE_NAME_FIELD,
            DATA_TABLE_COLUMNS_FIELD, COPY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataTableName;

    private final String dataTableColumns;

    private final String copyOptions;

    private CopyCommand(BuilderImpl builder) {
        this.dataTableName = builder.dataTableName;
        this.dataTableColumns = builder.dataTableColumns;
        this.copyOptions = builder.copyOptions;
    }

    /**
     * <p>
     * The name of the target table. The table must already exist in the database.
     * </p>
     * 
     * @return The name of the target table. The table must already exist in the database.
     */
    public final String dataTableName() {
        return dataTableName;
    }

    /**
     * <p>
     * A comma-separated list of column names.
     * </p>
     * 
     * @return A comma-separated list of column names.
     */
    public final String dataTableColumns() {
        return dataTableColumns;
    }

    /**
     * <p>
     * Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the
     * "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon
     * Redshift COPY command</a>. Some possible examples that would apply to Kinesis Data Firehose are as follows:
     * </p>
     * <p>
     * <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using lzop.
     * </p>
     * <p>
     * <code>delimiter '|'</code> - fields are delimited with "|" (this is the default delimiter).
     * </p>
     * <p>
     * <code>delimiter '|' escape</code> - the delimiter should be escaped.
     * </p>
     * <p>
     * <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are fixed width
     * in the source, with each width specified after every column in the table.
     * </p>
     * <p>
     * <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the format of
     * the data.
     * </p>
     * <p>
     * For more examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
     * examples</a>.
     * </p>
     * 
     * @return Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see
     *         the "Optional Parameters" section of <a
     *         href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some
     *         possible examples that would apply to Kinesis Data Firehose are as follows:</p>
     *         <p>
     *         <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using
     *         lzop.
     *         </p>
     *         <p>
     *         <code>delimiter '|'</code> - fields are delimited with "|" (this is the default delimiter).
     *         </p>
     *         <p>
     *         <code>delimiter '|' escape</code> - the delimiter should be escaped.
     *         </p>
     *         <p>
     *         <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are
     *         fixed width in the source, with each width specified after every column in the table.
     *         </p>
     *         <p>
     *         <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the
     *         format of the data.
     *         </p>
     *         <p>
     *         For more examples, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY
     *         command examples</a>.
     */
    public final String copyOptions() {
        return copyOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTableName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableColumns());
        hashCode = 31 * hashCode + Objects.hashCode(copyOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyCommand)) {
            return false;
        }
        CopyCommand other = (CopyCommand) obj;
        return Objects.equals(dataTableName(), other.dataTableName())
                && Objects.equals(dataTableColumns(), other.dataTableColumns())
                && Objects.equals(copyOptions(), other.copyOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyCommand").add("DataTableName", dataTableName()).add("DataTableColumns", dataTableColumns())
                .add("CopyOptions", copyOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTableName":
            return Optional.ofNullable(clazz.cast(dataTableName()));
        case "DataTableColumns":
            return Optional.ofNullable(clazz.cast(dataTableColumns()));
        case "CopyOptions":
            return Optional.ofNullable(clazz.cast(copyOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyCommand, T> g) {
        return obj -> g.apply((CopyCommand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyCommand> {
        /**
         * <p>
         * The name of the target table. The table must already exist in the database.
         * </p>
         * 
         * @param dataTableName
         *        The name of the target table. The table must already exist in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableName(String dataTableName);

        /**
         * <p>
         * A comma-separated list of column names.
         * </p>
         * 
         * @param dataTableColumns
         *        A comma-separated list of column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableColumns(String dataTableColumns);

        /**
         * <p>
         * Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the
         * "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon
         * Redshift COPY command</a>. Some possible examples that would apply to Kinesis Data Firehose are as follows:
         * </p>
         * <p>
         * <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using lzop.
         * </p>
         * <p>
         * <code>delimiter '|'</code> - fields are delimited with "|" (this is the default delimiter).
         * </p>
         * <p>
         * <code>delimiter '|' escape</code> - the delimiter should be escaped.
         * </p>
         * <p>
         * <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are fixed
         * width in the source, with each width specified after every column in the table.
         * </p>
         * <p>
         * <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the
         * format of the data.
         * </p>
         * <p>
         * For more examples, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY
         * command examples</a>.
         * </p>
         * 
         * @param copyOptions
         *        Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information,
         *        see the "Optional Parameters" section of <a
         *        href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>.
         *        Some possible examples that would apply to Kinesis Data Firehose are as follows:</p>
         *        <p>
         *        <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed
         *        using lzop.
         *        </p>
         *        <p>
         *        <code>delimiter '|'</code> - fields are delimited with "|" (this is the default delimiter).
         *        </p>
         *        <p>
         *        <code>delimiter '|' escape</code> - the delimiter should be escaped.
         *        </p>
         *        <p>
         *        <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are
         *        fixed width in the source, with each width specified after every column in the table.
         *        </p>
         *        <p>
         *        <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is
         *        the format of the data.
         *        </p>
         *        <p>
         *        For more examples, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift
         *        COPY command examples</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptions(String copyOptions);
    }

    static final class BuilderImpl implements Builder {
        private String dataTableName;

        private String dataTableColumns;

        private String copyOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyCommand model) {
            dataTableName(model.dataTableName);
            dataTableColumns(model.dataTableColumns);
            copyOptions(model.copyOptions);
        }

        public final String getDataTableName() {
            return dataTableName;
        }

        public final void setDataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
        }

        @Override
        @Transient
        public final Builder dataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
            return this;
        }

        public final String getDataTableColumns() {
            return dataTableColumns;
        }

        public final void setDataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
        }

        @Override
        @Transient
        public final Builder dataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
            return this;
        }

        public final String getCopyOptions() {
            return copyOptions;
        }

        public final void setCopyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
        }

        @Override
        @Transient
        public final Builder copyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
            return this;
        }

        @Override
        public CopyCommand build() {
            return new CopyCommand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
