/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for a destination in Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchDestinationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchDestinationUpdate.Builder, ElasticsearchDestinationUpdate> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(ElasticsearchDestinationUpdate::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainARN").getter(getter(ElasticsearchDestinationUpdate::domainARN)).setter(setter(Builder::domainARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()).build();

    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterEndpoint").getter(getter(ElasticsearchDestinationUpdate::clusterEndpoint))
            .setter(setter(Builder::clusterEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ElasticsearchDestinationUpdate::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ElasticsearchDestinationUpdate::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexRotationPeriod").getter(getter(ElasticsearchDestinationUpdate::indexRotationPeriodAsString))
            .setter(setter(Builder::indexRotationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build())
            .build();

    private static final SdkField<ElasticsearchBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<ElasticsearchBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(ElasticsearchDestinationUpdate::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(ElasticsearchBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<ElasticsearchRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<ElasticsearchRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(ElasticsearchDestinationUpdate::retryOptions)).setter(setter(Builder::retryOptions))
            .constructor(ElasticsearchRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField
            .<S3DestinationUpdate> builder(MarshallingType.SDK_POJO).memberName("S3Update")
            .getter(getter(ElasticsearchDestinationUpdate::s3Update)).setter(setter(Builder::s3Update))
            .constructor(S3DestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()).build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(ElasticsearchDestinationUpdate::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(ElasticsearchDestinationUpdate::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD,
            BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_UPDATE_FIELD, PROCESSING_CONFIGURATION_FIELD,
            CLOUD_WATCH_LOGGING_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String domainARN;

    private final String clusterEndpoint;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final ElasticsearchBufferingHints bufferingHints;

    private final ElasticsearchRetryOptions retryOptions;

    private final S3DestinationUpdate s3Update;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES
     * Configuration API and for indexing documents. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
     * Firehose Access to an Amazon S3 Destination</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the
     *         Amazon ES Configuration API and for indexing documents. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis
     *         Data Firehose Access to an Amazon S3 Destination</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeElasticsearchDomain</code>,
     * <code>DescribeElasticsearchDomains</code>, and <code>DescribeElasticsearchDomainConfig</code> after assuming the
     * IAM role specified in <code>RoleARN</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * <p>
     * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
     * </p>
     * 
     * @return The ARN of the Amazon ES domain. The IAM role must have permissions for 
     *         <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
     *         <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
     *         <code>RoleARN</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.</p>
     *         <p>
     *         Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
     */
    public final String domainARN() {
        return domainARN;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or the
     * <code>DomainARN</code> field.
     * </p>
     * 
     * @return The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code>
     *         or the <code>DomainARN</code> field.
     */
    public final String clusterEndpoint() {
        return clusterEndpoint;
    }

    /**
     * <p>
     * The Elasticsearch index name.
     * </p>
     * 
     * @return The Elasticsearch index name.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a
     * new type for an existing index that already has another type, Kinesis Data Firehose returns an error during
     * runtime.
     * </p>
     * <p>
     * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Kinesis Data Firehose still
     * delivers data to Elasticsearch with the old index name and type name. If you want to update your delivery stream
     * with a new index name, provide an empty string for <code>TypeName</code>.
     * </p>
     * 
     * @return The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to
     *         specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an
     *         error during runtime.</p>
     *         <p>
     *         If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Kinesis Data Firehose
     *         still delivers data to Elasticsearch with the old index name and type name. If you want to update your
     *         delivery stream with a new index name, provide an empty string for <code>TypeName</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
     * facilitate the expiration of old data. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
     *         facilitate the expiration of old data. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
     *         Rotation for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public final ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(indexRotationPeriod);
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
     * facilitate the expiration of old data. For more information, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
     *         facilitate the expiration of old data. For more information, see <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
     *         Rotation for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public final String indexRotationPeriodAsString() {
        return indexRotationPeriod;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object default values
     * are used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object default
     *         values are used.
     */
    public final ElasticsearchBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default value
     * is 300 (5 minutes).
     * </p>
     * 
     * @return The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
     *         value is 300 (5 minutes).
     */
    public final ElasticsearchRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * 
     * @return The Amazon S3 destination.
     */
    public final S3DestinationUpdate s3Update() {
        return s3Update;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationUpdate)) {
            return false;
        }
        ElasticsearchDestinationUpdate other = (ElasticsearchDestinationUpdate) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(domainARN(), other.domainARN())
                && Objects.equals(clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(typeName(), other.typeName())
                && Objects.equals(indexRotationPeriodAsString(), other.indexRotationPeriodAsString())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(retryOptions(), other.retryOptions()) && Objects.equals(s3Update(), other.s3Update())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchDestinationUpdate").add("RoleARN", roleARN()).add("DomainARN", domainARN())
                .add("ClusterEndpoint", clusterEndpoint()).add("IndexName", indexName()).add("TypeName", typeName())
                .add("IndexRotationPeriod", indexRotationPeriodAsString()).add("BufferingHints", bufferingHints())
                .add("RetryOptions", retryOptions()).add("S3Update", s3Update())
                .add("ProcessingConfiguration", processingConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "DomainARN":
            return Optional.ofNullable(clazz.cast(domainARN()));
        case "ClusterEndpoint":
            return Optional.ofNullable(clazz.cast(clusterEndpoint()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "IndexRotationPeriod":
            return Optional.ofNullable(clazz.cast(indexRotationPeriodAsString()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3Update":
            return Optional.ofNullable(clazz.cast(s3Update()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDestinationUpdate, T> g) {
        return obj -> g.apply((ElasticsearchDestinationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchDestinationUpdate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon
         * ES Configuration API and for indexing documents. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis
         * Data Firehose Access to an Amazon S3 Destination</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the
         *        Amazon ES Configuration API and for indexing documents. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant
         *        Kinesis Data Firehose Access to an Amazon S3 Destination</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the Amazon ES domain. The IAM role must have permissions for 
         * <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         * <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in <code>RoleARN</code>.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * <p>
         * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
         * </p>
         * 
         * @param domainARN
         *        The ARN of the Amazon ES domain. The IAM role must have permissions for 
         *        <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         *        <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
         *        <code>RoleARN</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.</p>
         *        <p>
         *        Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * <p>
         * The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or
         * the <code>DomainARN</code> field.
         * </p>
         * 
         * @param clusterEndpoint
         *        The endpoint to use when communicating with the cluster. Specify either this
         *        <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoint(String clusterEndpoint);

        /**
         * <p>
         * The Elasticsearch index name.
         * </p>
         * 
         * @param indexName
         *        The Elasticsearch index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to
         * specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an
         * error during runtime.
         * </p>
         * <p>
         * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Kinesis Data Firehose
         * still delivers data to Elasticsearch with the old index name and type name. If you want to update your
         * delivery stream with a new index name, provide an empty string for <code>TypeName</code>.
         * </p>
         * 
         * @param typeName
         *        The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try
         *        to specify a new type for an existing index that already has another type, Kinesis Data Firehose
         *        returns an error during runtime.</p>
         *        <p>
         *        If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Kinesis Data
         *        Firehose still delivers data to Elasticsearch with the old index name and type name. If you want to
         *        update your delivery stream with a new index name, provide an empty string for <code>TypeName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
         * facilitate the expiration of old data. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
         * for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code>
         *        to facilitate the expiration of old data. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to
         * facilitate the expiration of old data. For more information, see <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
         * for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code>
         *        to facilitate the expiration of old data. For more information, see <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod);

        /**
         * <p>
         * The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object default
         * values are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object
         *        default values are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(ElasticsearchBufferingHints bufferingHints);

        /**
         * <p>
         * The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object default
         * values are used.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchBufferingHints.Builder} avoiding
         * the need to create one manually via {@link ElasticsearchBufferingHints#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchBufferingHints.Builder#build()} is called
         * immediately and its result is passed to {@link #bufferingHints(ElasticsearchBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link ElasticsearchBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(ElasticsearchBufferingHints)
         */
        default Builder bufferingHints(Consumer<ElasticsearchBufferingHints.Builder> bufferingHints) {
            return bufferingHints(ElasticsearchBufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
         * value is 300 (5 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The
         *        default value is 300 (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(ElasticsearchRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default
         * value is 300 (5 minutes).
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchRetryOptions.Builder} avoiding the
         * need to create one manually via {@link ElasticsearchRetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchRetryOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #retryOptions(ElasticsearchRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link ElasticsearchRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(ElasticsearchRetryOptions)
         */
        default Builder retryOptions(Consumer<ElasticsearchRetryOptions.Builder> retryOptions) {
            return retryOptions(ElasticsearchRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * 
         * @param s3Update
         *        The Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Update(S3DestinationUpdate s3Update);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the need
         * to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Update(S3DestinationUpdate)}.
         * 
         * @param s3Update
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Update(S3DestinationUpdate)
         */
        default Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return s3Update(S3DestinationUpdate.builder().applyMutation(s3Update).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String clusterEndpoint;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private ElasticsearchBufferingHints bufferingHints;

        private ElasticsearchRetryOptions retryOptions;

        private S3DestinationUpdate s3Update;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationUpdate model) {
            roleARN(model.roleARN);
            domainARN(model.domainARN);
            clusterEndpoint(model.clusterEndpoint);
            indexName(model.indexName);
            typeName(model.typeName);
            indexRotationPeriod(model.indexRotationPeriod);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3Update(model.s3Update);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        @Transient
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        @Transient
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        @Transient
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        @Transient
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        @Transient
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return s3Update != null ? s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        @Override
        public ElasticsearchDestinationUpdate build() {
            return new ElasticsearchDestinationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
