/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the encryption for a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private static final SdkField<String> NO_ENCRYPTION_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoEncryptionConfig").getter(getter(EncryptionConfiguration::noEncryptionConfigAsString))
            .setter(setter(Builder::noEncryptionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoEncryptionConfig").build())
            .build();

    private static final SdkField<KMSEncryptionConfig> KMS_ENCRYPTION_CONFIG_FIELD = SdkField
            .<KMSEncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("KMSEncryptionConfig")
            .getter(getter(EncryptionConfiguration::kmsEncryptionConfig)).setter(setter(Builder::kmsEncryptionConfig))
            .constructor(KMSEncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_ENCRYPTION_CONFIG_FIELD,
            KMS_ENCRYPTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String noEncryptionConfig;

    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    /**
     * <p>
     * Specifically override existing encryption information to ensure that no encryption is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noEncryptionConfig} will return {@link NoEncryptionConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #noEncryptionConfigAsString}.
     * </p>
     * 
     * @return Specifically override existing encryption information to ensure that no encryption is used.
     * @see NoEncryptionConfig
     */
    public final NoEncryptionConfig noEncryptionConfig() {
        return NoEncryptionConfig.fromValue(noEncryptionConfig);
    }

    /**
     * <p>
     * Specifically override existing encryption information to ensure that no encryption is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noEncryptionConfig} will return {@link NoEncryptionConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #noEncryptionConfigAsString}.
     * </p>
     * 
     * @return Specifically override existing encryption information to ensure that no encryption is used.
     * @see NoEncryptionConfig
     */
    public final String noEncryptionConfigAsString() {
        return noEncryptionConfig;
    }

    /**
     * <p>
     * The encryption key.
     * </p>
     * 
     * @return The encryption key.
     */
    public final KMSEncryptionConfig kmsEncryptionConfig() {
        return kmsEncryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noEncryptionConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(noEncryptionConfigAsString(), other.noEncryptionConfigAsString())
                && Objects.equals(kmsEncryptionConfig(), other.kmsEncryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfiguration").add("NoEncryptionConfig", noEncryptionConfigAsString())
                .add("KMSEncryptionConfig", kmsEncryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NoEncryptionConfig":
            return Optional.ofNullable(clazz.cast(noEncryptionConfigAsString()));
        case "KMSEncryptionConfig":
            return Optional.ofNullable(clazz.cast(kmsEncryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * Specifically override existing encryption information to ensure that no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure that no encryption is used.
         * @see NoEncryptionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(String noEncryptionConfig);

        /**
         * <p>
         * Specifically override existing encryption information to ensure that no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure that no encryption is used.
         * @see NoEncryptionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig);

        /**
         * <p>
         * The encryption key.
         * </p>
         * 
         * @param kmsEncryptionConfig
         *        The encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig);

        /**
         * <p>
         * The encryption key.
         * </p>
         * This is a convenience that creates an instance of the {@link KMSEncryptionConfig.Builder} avoiding the need
         * to create one manually via {@link KMSEncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link KMSEncryptionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kmsEncryptionConfig(KMSEncryptionConfig)}.
         * 
         * @param kmsEncryptionConfig
         *        a consumer that will call methods on {@link KMSEncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsEncryptionConfig(KMSEncryptionConfig)
         */
        default Builder kmsEncryptionConfig(Consumer<KMSEncryptionConfig.Builder> kmsEncryptionConfig) {
            return kmsEncryptionConfig(KMSEncryptionConfig.builder().applyMutation(kmsEncryptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String noEncryptionConfig;

        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            noEncryptionConfig(model.noEncryptionConfig);
            kmsEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return noEncryptionConfig;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        @Override
        @Transient
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        @Transient
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig == null ? null : noEncryptionConfig.toString());
            return this;
        }

        public final KMSEncryptionConfig.Builder getKmsEncryptionConfig() {
            return kmsEncryptionConfig != null ? kmsEncryptionConfig.toBuilder() : null;
        }

        public final void setKmsEncryptionConfig(KMSEncryptionConfig.BuilderImpl kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig != null ? kmsEncryptionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
