/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeliveryStreamsRequest extends FirehoseRequest implements
        ToCopyableBuilder<ListDeliveryStreamsRequest.Builder, ListDeliveryStreamsRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListDeliveryStreamsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> DELIVERY_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamType").getter(getter(ListDeliveryStreamsRequest::deliveryStreamTypeAsString))
            .setter(setter(Builder::deliveryStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamType").build())
            .build();

    private static final SdkField<String> EXCLUSIVE_START_DELIVERY_STREAM_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartDeliveryStreamName")
            .getter(getter(ListDeliveryStreamsRequest::exclusiveStartDeliveryStreamName))
            .setter(setter(Builder::exclusiveStartDeliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartDeliveryStreamName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD,
            DELIVERY_STREAM_TYPE_FIELD, EXCLUSIVE_START_DELIVERY_STREAM_NAME_FIELD));

    private final Integer limit;

    private final String deliveryStreamType;

    private final String exclusiveStartDeliveryStreamName;

    private ListDeliveryStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.exclusiveStartDeliveryStreamName = builder.exclusiveStartDeliveryStreamName;
    }

    /**
     * <p>
     * The maximum number of delivery streams to list. The default value is 10.
     * </p>
     * 
     * @return The maximum number of delivery streams to list. The default value is 10.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The delivery stream type. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeAsString}.
     * </p>
     * 
     * @return The delivery stream type. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * @see DeliveryStreamType
     */
    public final DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(deliveryStreamType);
    }

    /**
     * <p>
     * The delivery stream type. This can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeAsString}.
     * </p>
     * 
     * @return The delivery stream type. This can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     * @see DeliveryStreamType
     */
    public final String deliveryStreamTypeAsString() {
        return deliveryStreamType;
    }

    /**
     * <p>
     * The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the
     * delivery stream whose name comes alphabetically immediately after the name you specify in
     * <code>ExclusiveStartDeliveryStreamName</code>.
     * </p>
     * 
     * @return The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with
     *         the delivery stream whose name comes alphabetically immediately after the name you specify in
     *         <code>ExclusiveStartDeliveryStreamName</code>.
     */
    public final String exclusiveStartDeliveryStreamName() {
        return exclusiveStartDeliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartDeliveryStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsRequest)) {
            return false;
        }
        ListDeliveryStreamsRequest other = (ListDeliveryStreamsRequest) obj;
        return Objects.equals(limit(), other.limit())
                && Objects.equals(deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString())
                && Objects.equals(exclusiveStartDeliveryStreamName(), other.exclusiveStartDeliveryStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeliveryStreamsRequest").add("Limit", limit())
                .add("DeliveryStreamType", deliveryStreamTypeAsString())
                .add("ExclusiveStartDeliveryStreamName", exclusiveStartDeliveryStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "DeliveryStreamType":
            return Optional.ofNullable(clazz.cast(deliveryStreamTypeAsString()));
        case "ExclusiveStartDeliveryStreamName":
            return Optional.ofNullable(clazz.cast(exclusiveStartDeliveryStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliveryStreamsRequest, T> g) {
        return obj -> g.apply((ListDeliveryStreamsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeliveryStreamsRequest> {
        /**
         * <p>
         * The maximum number of delivery streams to list. The default value is 10.
         * </p>
         * 
         * @param limit
         *        The maximum number of delivery streams to list. The default value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The delivery stream type. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * </p>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(String deliveryStreamType);

        /**
         * <p>
         * The delivery stream type. This can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * </p>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(DeliveryStreamType deliveryStreamType);

        /**
         * <p>
         * The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the
         * delivery stream whose name comes alphabetically immediately after the name you specify in
         * <code>ExclusiveStartDeliveryStreamName</code>.
         * </p>
         * 
         * @param exclusiveStartDeliveryStreamName
         *        The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with
         *        the delivery stream whose name comes alphabetically immediately after the name you specify in
         *        <code>ExclusiveStartDeliveryStreamName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String deliveryStreamType;

        private String exclusiveStartDeliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsRequest model) {
            super(model);
            limit(model.limit);
            deliveryStreamType(model.deliveryStreamType);
            exclusiveStartDeliveryStreamName(model.exclusiveStartDeliveryStreamName);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getDeliveryStreamType() {
            return deliveryStreamType;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        @Override
        @Transient
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        @Transient
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType == null ? null : deliveryStreamType.toString());
            return this;
        }

        public final String getExclusiveStartDeliveryStreamName() {
            return exclusiveStartDeliveryStreamName;
        }

        public final void setExclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
        }

        @Override
        @Transient
        public final Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeliveryStreamsRequest build() {
            return new ListDeliveryStreamsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
