/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeliveryStreamEncryptionRequest extends FirehoseRequest implements
        ToCopyableBuilder<StartDeliveryStreamEncryptionRequest.Builder, StartDeliveryStreamEncryptionRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamName").getter(getter(StartDeliveryStreamEncryptionRequest::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build())
            .build();

    private static final SdkField<DeliveryStreamEncryptionConfigurationInput> DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD = SdkField
            .<DeliveryStreamEncryptionConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("DeliveryStreamEncryptionConfigurationInput")
            .getter(getter(StartDeliveryStreamEncryptionRequest::deliveryStreamEncryptionConfigurationInput))
            .setter(setter(Builder::deliveryStreamEncryptionConfigurationInput))
            .constructor(DeliveryStreamEncryptionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeliveryStreamEncryptionConfigurationInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD));

    private final String deliveryStreamName;

    private final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

    private StartDeliveryStreamEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
    }

    /**
     * <p>
     * The name of the delivery stream for which you want to enable server-side encryption (SSE).
     * </p>
     * 
     * @return The name of the delivery stream for which you want to enable server-side encryption (SSE).
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).
     * </p>
     * 
     * @return Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
     *         (SSE).
     */
    public final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput() {
        return deliveryStreamEncryptionConfigurationInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamEncryptionConfigurationInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeliveryStreamEncryptionRequest)) {
            return false;
        }
        StartDeliveryStreamEncryptionRequest other = (StartDeliveryStreamEncryptionRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(deliveryStreamEncryptionConfigurationInput(),
                        other.deliveryStreamEncryptionConfigurationInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeliveryStreamEncryptionRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("DeliveryStreamEncryptionConfigurationInput", deliveryStreamEncryptionConfigurationInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "DeliveryStreamEncryptionConfigurationInput":
            return Optional.ofNullable(clazz.cast(deliveryStreamEncryptionConfigurationInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeliveryStreamEncryptionRequest, T> g) {
        return obj -> g.apply((StartDeliveryStreamEncryptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDeliveryStreamEncryptionRequest> {
        /**
         * <p>
         * The name of the delivery stream for which you want to enable server-side encryption (SSE).
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream for which you want to enable server-side encryption (SSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
         * (SSE).
         * </p>
         * 
         * @param deliveryStreamEncryptionConfigurationInput
         *        Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side
         *        Encryption (SSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput);

        /**
         * <p>
         * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
         * (SSE).
         * </p>
         * This is a convenience that creates an instance of the
         * {@link DeliveryStreamEncryptionConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link DeliveryStreamEncryptionConfigurationInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeliveryStreamEncryptionConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput)}.
         * 
         * @param deliveryStreamEncryptionConfigurationInput
         *        a consumer that will call methods on {@link DeliveryStreamEncryptionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput)
         */
        default Builder deliveryStreamEncryptionConfigurationInput(
                Consumer<DeliveryStreamEncryptionConfigurationInput.Builder> deliveryStreamEncryptionConfigurationInput) {
            return deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput.builder()
                    .applyMutation(deliveryStreamEncryptionConfigurationInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeliveryStreamEncryptionRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            deliveryStreamEncryptionConfigurationInput(model.deliveryStreamEncryptionConfigurationInput);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        @Transient
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final DeliveryStreamEncryptionConfigurationInput.Builder getDeliveryStreamEncryptionConfigurationInput() {
            return deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput.toBuilder()
                    : null;
        }

        public final void setDeliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput.BuilderImpl deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder deliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeliveryStreamEncryptionRequest build() {
            return new StartDeliveryStreamEncryptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
