/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.firehose.DefaultFirehoseBaseClientBuilder;
import software.amazon.awssdk.services.firehose.DefaultFirehoseClient;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.FirehoseClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseServiceClientConfiguration;
import software.amazon.awssdk.services.firehose.endpoints.FirehoseEndpointProvider;

@SdkInternalApi
final class DefaultFirehoseClientBuilder
extends DefaultFirehoseBaseClientBuilder<FirehoseClientBuilder, FirehoseClient>
implements FirehoseClientBuilder {
    DefaultFirehoseClientBuilder() {
    }

    @Override
    public DefaultFirehoseClientBuilder endpointProvider(FirehoseEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FirehoseClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFirehoseClientBuilder.validateClientOptions(clientConfiguration);
        FirehoseServiceClientConfiguration serviceClientConfiguration = FirehoseServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultFirehoseClient(serviceClientConfiguration, clientConfiguration);
    }
}

