/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessorType {
    RECORD_DE_AGGREGATION("RecordDeAggregation"),
    DECOMPRESSION("Decompression"),
    LAMBDA("Lambda"),
    METADATA_EXTRACTION("MetadataExtraction"),
    APPEND_DELIMITER_TO_RECORD("AppendDelimiterToRecord"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessorType> VALUE_MAP;
    private final String value;

    private ProcessorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessorType> knownValues() {
        EnumSet<ProcessorType> knownValues = EnumSet.allOf(ProcessorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessorType.class, ProcessorType::toString);
    }
}

