/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Amazon MSK cluster used as the source for a Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MSKSourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<MSKSourceDescription.Builder, MSKSourceDescription> {
    private static final SdkField<String> MSK_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MSKClusterARN").getter(getter(MSKSourceDescription::mskClusterARN))
            .setter(setter(Builder::mskClusterARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKClusterARN").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(MSKSourceDescription::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationConfiguration")
            .getter(getter(MSKSourceDescription::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration")
                    .build()).build();

    private static final SdkField<Instant> DELIVERY_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeliveryStartTimestamp").getter(getter(MSKSourceDescription::deliveryStartTimestamp))
            .setter(setter(Builder::deliveryStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStartTimestamp").build())
            .build();

    private static final SdkField<Instant> READ_FROM_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReadFromTimestamp").getter(getter(MSKSourceDescription::readFromTimestamp))
            .setter(setter(Builder::readFromTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadFromTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MSK_CLUSTER_ARN_FIELD,
            TOPIC_NAME_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, DELIVERY_START_TIMESTAMP_FIELD, READ_FROM_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mskClusterARN;

    private final String topicName;

    private final AuthenticationConfiguration authenticationConfiguration;

    private final Instant deliveryStartTimestamp;

    private final Instant readFromTimestamp;

    private MSKSourceDescription(BuilderImpl builder) {
        this.mskClusterARN = builder.mskClusterARN;
        this.topicName = builder.topicName;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
        this.readFromTimestamp = builder.readFromTimestamp;
    }

    /**
     * <p>
     * The ARN of the Amazon MSK cluster.
     * </p>
     * 
     * @return The ARN of the Amazon MSK cluster.
     */
    public final String mskClusterARN() {
        return mskClusterARN;
    }

    /**
     * <p>
     * The topic name within the Amazon MSK cluster.
     * </p>
     * 
     * @return The topic name within the Amazon MSK cluster.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The authentication configuration of the Amazon MSK cluster.
     * </p>
     * 
     * @return The authentication configuration of the Amazon MSK cluster.
     */
    public final AuthenticationConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this timestamp.
     * </p>
     * 
     * @return Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this
     *         timestamp.
     */
    public final Instant deliveryStartTimestamp() {
        return deliveryStartTimestamp;
    }

    /**
     * <p>
     * The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read.
     * By default, this is set to timestamp when Firehose becomes Active.
     * </p>
     * <p>
     * If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the
     * <code>ReadFromTimestampUTC</code> parameter to Epoch (1970-01-01T00:00:00Z).
     * </p>
     * 
     * @return The start date and time in UTC for the offset position within your MSK topic from where Firehose begins
     *         to read. By default, this is set to timestamp when Firehose becomes Active. </p>
     *         <p>
     *         If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the
     *         <code>ReadFromTimestampUTC</code> parameter to Epoch (1970-01-01T00:00:00Z).
     */
    public final Instant readFromTimestamp() {
        return readFromTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mskClusterARN());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(readFromTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MSKSourceDescription)) {
            return false;
        }
        MSKSourceDescription other = (MSKSourceDescription) obj;
        return Objects.equals(mskClusterARN(), other.mskClusterARN()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && Objects.equals(deliveryStartTimestamp(), other.deliveryStartTimestamp())
                && Objects.equals(readFromTimestamp(), other.readFromTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MSKSourceDescription").add("MSKClusterARN", mskClusterARN()).add("TopicName", topicName())
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("DeliveryStartTimestamp", deliveryStartTimestamp()).add("ReadFromTimestamp", readFromTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MSKClusterARN":
            return Optional.ofNullable(clazz.cast(mskClusterARN()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "AuthenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "DeliveryStartTimestamp":
            return Optional.ofNullable(clazz.cast(deliveryStartTimestamp()));
        case "ReadFromTimestamp":
            return Optional.ofNullable(clazz.cast(readFromTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MSKSourceDescription, T> g) {
        return obj -> g.apply((MSKSourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MSKSourceDescription> {
        /**
         * <p>
         * The ARN of the Amazon MSK cluster.
         * </p>
         * 
         * @param mskClusterARN
         *        The ARN of the Amazon MSK cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mskClusterARN(String mskClusterARN);

        /**
         * <p>
         * The topic name within the Amazon MSK cluster.
         * </p>
         * 
         * @param topicName
         *        The topic name within the Amazon MSK cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The authentication configuration of the Amazon MSK cluster.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration of the Amazon MSK cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration of the Amazon MSK cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(AuthenticationConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)
                    .build());
        }

        /**
         * <p>
         * Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this timestamp.
         * </p>
         * 
         * @param deliveryStartTimestamp
         *        Firehose starts retrieving records from the topic within the Amazon MSK cluster starting with this
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStartTimestamp(Instant deliveryStartTimestamp);

        /**
         * <p>
         * The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to
         * read. By default, this is set to timestamp when Firehose becomes Active.
         * </p>
         * <p>
         * If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the
         * <code>ReadFromTimestampUTC</code> parameter to Epoch (1970-01-01T00:00:00Z).
         * </p>
         * 
         * @param readFromTimestamp
         *        The start date and time in UTC for the offset position within your MSK topic from where Firehose
         *        begins to read. By default, this is set to timestamp when Firehose becomes Active. </p>
         *        <p>
         *        If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set
         *        the <code>ReadFromTimestampUTC</code> parameter to Epoch (1970-01-01T00:00:00Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readFromTimestamp(Instant readFromTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String mskClusterARN;

        private String topicName;

        private AuthenticationConfiguration authenticationConfiguration;

        private Instant deliveryStartTimestamp;

        private Instant readFromTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MSKSourceDescription model) {
            mskClusterARN(model.mskClusterARN);
            topicName(model.topicName);
            authenticationConfiguration(model.authenticationConfiguration);
            deliveryStartTimestamp(model.deliveryStartTimestamp);
            readFromTimestamp(model.readFromTimestamp);
        }

        public final String getMskClusterARN() {
            return mskClusterARN;
        }

        public final void setMskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
        }

        @Override
        public final Builder mskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Instant getDeliveryStartTimestamp() {
            return deliveryStartTimestamp;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        public final Instant getReadFromTimestamp() {
            return readFromTimestamp;
        }

        public final void setReadFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
        }

        @Override
        public final Builder readFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
            return this;
        }

        @Override
        public MSKSourceDescription build() {
            return new MSKSourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
