/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any
 * value, Firehose uses the default values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeBufferingHints implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeBufferingHints.Builder, SnowflakeBufferingHints> {
    private static final SdkField<Integer> SIZE_IN_M_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMBs").getter(getter(SnowflakeBufferingHints::sizeInMBs)).setter(setter(Builder::sizeInMBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMBs").build()).build();

    private static final SdkField<Integer> INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntervalInSeconds").getter(getter(SnowflakeBufferingHints::intervalInSeconds))
            .setter(setter(Builder::intervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_M_BS_FIELD,
            INTERVAL_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeInMBs;

    private final Integer intervalInSeconds;

    private SnowflakeBufferingHints(BuilderImpl builder) {
        this.sizeInMBs = builder.sizeInMBs;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    /**
     * <p>
     * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is
     * 1.
     * </p>
     * 
     * @return Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default
     *         value is 1.
     */
    public final Integer sizeInMBs() {
        return sizeInMBs;
    }

    /**
     * <p>
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The
     * default value is 0.
     * </p>
     * 
     * @return Buffer incoming data for the specified period of time, in seconds, before delivering it to the
     *         destination. The default value is 0.
     */
    public final Integer intervalInSeconds() {
        return intervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMBs());
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeBufferingHints)) {
            return false;
        }
        SnowflakeBufferingHints other = (SnowflakeBufferingHints) obj;
        return Objects.equals(sizeInMBs(), other.sizeInMBs()) && Objects.equals(intervalInSeconds(), other.intervalInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeBufferingHints").add("SizeInMBs", sizeInMBs())
                .add("IntervalInSeconds", intervalInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInMBs":
            return Optional.ofNullable(clazz.cast(sizeInMBs()));
        case "IntervalInSeconds":
            return Optional.ofNullable(clazz.cast(intervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeBufferingHints, T> g) {
        return obj -> g.apply((SnowflakeBufferingHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeBufferingHints> {
        /**
         * <p>
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default
         * value is 1.
         * </p>
         * 
         * @param sizeInMBs
         *        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The
         *        default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMBs(Integer sizeInMBs);

        /**
         * <p>
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * The default value is 0.
         * </p>
         * 
         * @param intervalInSeconds
         *        Buffer incoming data for the specified period of time, in seconds, before delivering it to the
         *        destination. The default value is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Integer intervalInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMBs;

        private Integer intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeBufferingHints model) {
            sizeInMBs(model.sizeInMBs);
            intervalInSeconds(model.intervalInSeconds);
        }

        public final Integer getSizeInMBs() {
            return sizeInMBs;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final Integer getIntervalInSeconds() {
            return intervalInSeconds;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        @Override
        public SnowflakeBufferingHints build() {
            return new SnowflakeBufferingHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
