/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional Snowflake destination description
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeDestinationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeDestinationDescription.Builder, SnowflakeDestinationDescription> {
    private static final SdkField<String> ACCOUNT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountUrl").getter(getter(SnowflakeDestinationDescription::accountUrl))
            .setter(setter(Builder::accountUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountUrl").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(SnowflakeDestinationDescription::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(SnowflakeDestinationDescription::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(SnowflakeDestinationDescription::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(SnowflakeDestinationDescription::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<SnowflakeRoleConfiguration> SNOWFLAKE_ROLE_CONFIGURATION_FIELD = SdkField
            .<SnowflakeRoleConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SnowflakeRoleConfiguration")
            .getter(getter(SnowflakeDestinationDescription::snowflakeRoleConfiguration))
            .setter(setter(Builder::snowflakeRoleConfiguration))
            .constructor(SnowflakeRoleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeRoleConfiguration").build())
            .build();

    private static final SdkField<String> DATA_LOADING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataLoadingOption").getter(getter(SnowflakeDestinationDescription::dataLoadingOptionAsString))
            .setter(setter(Builder::dataLoadingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLoadingOption").build()).build();

    private static final SdkField<String> META_DATA_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetaDataColumnName").getter(getter(SnowflakeDestinationDescription::metaDataColumnName))
            .setter(setter(Builder::metaDataColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaDataColumnName").build())
            .build();

    private static final SdkField<String> CONTENT_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentColumnName").getter(getter(SnowflakeDestinationDescription::contentColumnName))
            .setter(setter(Builder::contentColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentColumnName").build()).build();

    private static final SdkField<SnowflakeVpcConfiguration> SNOWFLAKE_VPC_CONFIGURATION_FIELD = SdkField
            .<SnowflakeVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnowflakeVpcConfiguration")
            .getter(getter(SnowflakeDestinationDescription::snowflakeVpcConfiguration))
            .setter(setter(Builder::snowflakeVpcConfiguration)).constructor(SnowflakeVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeVpcConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(SnowflakeDestinationDescription::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(SnowflakeDestinationDescription::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(SnowflakeDestinationDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<SnowflakeRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<SnowflakeRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(SnowflakeDestinationDescription::retryOptions)).setter(setter(Builder::retryOptions))
            .constructor(SnowflakeRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(SnowflakeDestinationDescription::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<S3DestinationDescription> builder(MarshallingType.SDK_POJO).memberName("S3DestinationDescription")
            .getter(getter(SnowflakeDestinationDescription::s3DestinationDescription))
            .setter(setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build())
            .build();

    private static final SdkField<SecretsManagerConfiguration> SECRETS_MANAGER_CONFIGURATION_FIELD = SdkField
            .<SecretsManagerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SecretsManagerConfiguration")
            .getter(getter(SnowflakeDestinationDescription::secretsManagerConfiguration))
            .setter(setter(Builder::secretsManagerConfiguration))
            .constructor(SecretsManagerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerConfiguration")
                    .build()).build();

    private static final SdkField<SnowflakeBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<SnowflakeBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(SnowflakeDestinationDescription::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(SnowflakeBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_URL_FIELD, USER_FIELD,
            DATABASE_FIELD, SCHEMA_FIELD, TABLE_FIELD, SNOWFLAKE_ROLE_CONFIGURATION_FIELD, DATA_LOADING_OPTION_FIELD,
            META_DATA_COLUMN_NAME_FIELD, CONTENT_COLUMN_NAME_FIELD, SNOWFLAKE_VPC_CONFIGURATION_FIELD,
            CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD,
            S3_BACKUP_MODE_FIELD, S3_DESTINATION_DESCRIPTION_FIELD, SECRETS_MANAGER_CONFIGURATION_FIELD, BUFFERING_HINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountUrl;

    private final String user;

    private final String database;

    private final String schema;

    private final String table;

    private final SnowflakeRoleConfiguration snowflakeRoleConfiguration;

    private final String dataLoadingOption;

    private final String metaDataColumnName;

    private final String contentColumnName;

    private final SnowflakeVpcConfiguration snowflakeVpcConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final ProcessingConfiguration processingConfiguration;

    private final String roleARN;

    private final SnowflakeRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationDescription s3DestinationDescription;

    private final SecretsManagerConfiguration secretsManagerConfiguration;

    private final SnowflakeBufferingHints bufferingHints;

    private SnowflakeDestinationDescription(BuilderImpl builder) {
        this.accountUrl = builder.accountUrl;
        this.user = builder.user;
        this.database = builder.database;
        this.schema = builder.schema;
        this.table = builder.table;
        this.snowflakeRoleConfiguration = builder.snowflakeRoleConfiguration;
        this.dataLoadingOption = builder.dataLoadingOption;
        this.metaDataColumnName = builder.metaDataColumnName;
        this.contentColumnName = builder.contentColumnName;
        this.snowflakeVpcConfiguration = builder.snowflakeVpcConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
        this.bufferingHints = builder.bufferingHints;
    }

    /**
     * <p>
     * URL for accessing your Snowflake account. This URL must include your <a
     * href="https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a>. Note that the
     * protocol (https://) and port number are optional.
     * </p>
     * 
     * @return URL for accessing your Snowflake account. This URL must include your <a
     *         href="https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a>. Note
     *         that the protocol (https://) and port number are optional.
     */
    public final String accountUrl() {
        return accountUrl;
    }

    /**
     * <p>
     * User login name for the Snowflake account.
     * </p>
     * 
     * @return User login name for the Snowflake account.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * All data in Snowflake is maintained in databases.
     * </p>
     * 
     * @return All data in Snowflake is maintained in databases.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables
     * and views
     * </p>
     * 
     * @return Each database consists of one or more schemas, which are logical groupings of database objects, such as
     *         tables and views
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
     * </p>
     * 
     * @return All data in Snowflake is stored in database tables, logically structured as collections of columns and
     *         rows.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * Optionally configure a Snowflake role. Otherwise the default user role will be used.
     * </p>
     * 
     * @return Optionally configure a Snowflake role. Otherwise the default user role will be used.
     */
    public final SnowflakeRoleConfiguration snowflakeRoleConfiguration() {
        return snowflakeRoleConfiguration;
    }

    /**
     * <p>
     * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped
     * to a record content column and source metadata is mapped to a record metadata column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataLoadingOption}
     * will return {@link SnowflakeDataLoadingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataLoadingOptionAsString}.
     * </p>
     * 
     * @return Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content
     *         is mapped to a record content column and source metadata is mapped to a record metadata column.
     * @see SnowflakeDataLoadingOption
     */
    public final SnowflakeDataLoadingOption dataLoadingOption() {
        return SnowflakeDataLoadingOption.fromValue(dataLoadingOption);
    }

    /**
     * <p>
     * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped
     * to a record content column and source metadata is mapped to a record metadata column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataLoadingOption}
     * will return {@link SnowflakeDataLoadingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataLoadingOptionAsString}.
     * </p>
     * 
     * @return Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content
     *         is mapped to a record content column and source metadata is mapped to a record metadata column.
     * @see SnowflakeDataLoadingOption
     */
    public final String dataLoadingOptionAsString() {
        return dataLoadingOption;
    }

    /**
     * <p>
     * The name of the record metadata column
     * </p>
     * 
     * @return The name of the record metadata column
     */
    public final String metaDataColumnName() {
        return metaDataColumnName;
    }

    /**
     * <p>
     * The name of the record content column
     * </p>
     * 
     * @return The name of the record content column
     */
    public final String contentColumnName() {
        return contentColumnName;
    }

    /**
     * <p>
     * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
     * com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
     * href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
     * </p>
     * 
     * @return The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
     *         com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
     *         href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
     *         Snowflake</a>
     */
    public final SnowflakeVpcConfiguration snowflakeVpcConfiguration() {
        return snowflakeVpcConfiguration;
    }

    /**
     * Returns the value of the CloudWatchLoggingOptions property for this object.
     * 
     * @return The value of the CloudWatchLoggingOptions property for this object.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * Returns the value of the ProcessingConfiguration property for this object.
     * 
     * @return The value of the ProcessingConfiguration property for this object.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Snowflake role
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Snowflake role
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
     * </p>
     * 
     * @return The time period where Firehose will retry sending data to the chosen HTTP endpoint.
     */
    public final SnowflakeRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Choose an S3 backup mode
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link SnowflakeS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Choose an S3 backup mode
     * @see SnowflakeS3BackupMode
     */
    public final SnowflakeS3BackupMode s3BackupMode() {
        return SnowflakeS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Choose an S3 backup mode
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link SnowflakeS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Choose an S3 backup mode
     * @see SnowflakeS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * Returns the value of the S3DestinationDescription property for this object.
     * 
     * @return The value of the S3DestinationDescription property for this object.
     */
    public final S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The configuration that defines how you access secrets for Snowflake.
     * </p>
     * 
     * @return The configuration that defines how you access secrets for Snowflake.
     */
    public final SecretsManagerConfiguration secretsManagerConfiguration() {
        return secretsManagerConfiguration;
    }

    /**
     * <p>
     * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify any
     * value, Firehose uses the default values.
     * </p>
     * 
     * @return Describes the buffering to perform before delivering data to the Snowflake destination. If you do not
     *         specify any value, Firehose uses the default values.
     */
    public final SnowflakeBufferingHints bufferingHints() {
        return bufferingHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountUrl());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(snowflakeRoleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataLoadingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metaDataColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(contentColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(snowflakeVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeDestinationDescription)) {
            return false;
        }
        SnowflakeDestinationDescription other = (SnowflakeDestinationDescription) obj;
        return Objects.equals(accountUrl(), other.accountUrl()) && Objects.equals(user(), other.user())
                && Objects.equals(database(), other.database()) && Objects.equals(schema(), other.schema())
                && Objects.equals(table(), other.table())
                && Objects.equals(snowflakeRoleConfiguration(), other.snowflakeRoleConfiguration())
                && Objects.equals(dataLoadingOptionAsString(), other.dataLoadingOptionAsString())
                && Objects.equals(metaDataColumnName(), other.metaDataColumnName())
                && Objects.equals(contentColumnName(), other.contentColumnName())
                && Objects.equals(snowflakeVpcConfiguration(), other.snowflakeVpcConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(roleARN(), other.roleARN()) && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3DestinationDescription(), other.s3DestinationDescription())
                && Objects.equals(secretsManagerConfiguration(), other.secretsManagerConfiguration())
                && Objects.equals(bufferingHints(), other.bufferingHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeDestinationDescription")
                .add("AccountUrl", accountUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("User", user() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Database", database() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Schema", schema() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Table", table() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnowflakeRoleConfiguration", snowflakeRoleConfiguration())
                .add("DataLoadingOption", dataLoadingOptionAsString())
                .add("MetaDataColumnName", metaDataColumnName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentColumnName", contentColumnName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnowflakeVpcConfiguration", snowflakeVpcConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions())
                .add("ProcessingConfiguration", processingConfiguration()).add("RoleARN", roleARN())
                .add("RetryOptions", retryOptions()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3DestinationDescription", s3DestinationDescription())
                .add("SecretsManagerConfiguration", secretsManagerConfiguration()).add("BufferingHints", bufferingHints())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountUrl":
            return Optional.ofNullable(clazz.cast(accountUrl()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "SnowflakeRoleConfiguration":
            return Optional.ofNullable(clazz.cast(snowflakeRoleConfiguration()));
        case "DataLoadingOption":
            return Optional.ofNullable(clazz.cast(dataLoadingOptionAsString()));
        case "MetaDataColumnName":
            return Optional.ofNullable(clazz.cast(metaDataColumnName()));
        case "ContentColumnName":
            return Optional.ofNullable(clazz.cast(contentColumnName()));
        case "SnowflakeVpcConfiguration":
            return Optional.ofNullable(clazz.cast(snowflakeVpcConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3DestinationDescription":
            return Optional.ofNullable(clazz.cast(s3DestinationDescription()));
        case "SecretsManagerConfiguration":
            return Optional.ofNullable(clazz.cast(secretsManagerConfiguration()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeDestinationDescription, T> g) {
        return obj -> g.apply((SnowflakeDestinationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeDestinationDescription> {
        /**
         * <p>
         * URL for accessing your Snowflake account. This URL must include your <a
         * href="https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a>. Note that
         * the protocol (https://) and port number are optional.
         * </p>
         * 
         * @param accountUrl
         *        URL for accessing your Snowflake account. This URL must include your <a
         *        href="https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a>. Note
         *        that the protocol (https://) and port number are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountUrl(String accountUrl);

        /**
         * <p>
         * User login name for the Snowflake account.
         * </p>
         * 
         * @param user
         *        User login name for the Snowflake account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * All data in Snowflake is maintained in databases.
         * </p>
         * 
         * @param database
         *        All data in Snowflake is maintained in databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Each database consists of one or more schemas, which are logical groupings of database objects, such as
         * tables and views
         * </p>
         * 
         * @param schema
         *        Each database consists of one or more schemas, which are logical groupings of database objects, such
         *        as tables and views
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
         * </p>
         * 
         * @param table
         *        All data in Snowflake is stored in database tables, logically structured as collections of columns and
         *        rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * Optionally configure a Snowflake role. Otherwise the default user role will be used.
         * </p>
         * 
         * @param snowflakeRoleConfiguration
         *        Optionally configure a Snowflake role. Otherwise the default user role will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration snowflakeRoleConfiguration);

        /**
         * <p>
         * Optionally configure a Snowflake role. Otherwise the default user role will be used.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeRoleConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnowflakeRoleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeRoleConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #snowflakeRoleConfiguration(SnowflakeRoleConfiguration)}.
         * 
         * @param snowflakeRoleConfiguration
         *        a consumer that will call methods on {@link SnowflakeRoleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflakeRoleConfiguration(SnowflakeRoleConfiguration)
         */
        default Builder snowflakeRoleConfiguration(Consumer<SnowflakeRoleConfiguration.Builder> snowflakeRoleConfiguration) {
            return snowflakeRoleConfiguration(SnowflakeRoleConfiguration.builder().applyMutation(snowflakeRoleConfiguration)
                    .build());
        }

        /**
         * <p>
         * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is
         * mapped to a record content column and source metadata is mapped to a record metadata column.
         * </p>
         * 
         * @param dataLoadingOption
         *        Choose to load JSON keys mapped to table column names or choose to split the JSON payload where
         *        content is mapped to a record content column and source metadata is mapped to a record metadata
         *        column.
         * @see SnowflakeDataLoadingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowflakeDataLoadingOption
         */
        Builder dataLoadingOption(String dataLoadingOption);

        /**
         * <p>
         * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is
         * mapped to a record content column and source metadata is mapped to a record metadata column.
         * </p>
         * 
         * @param dataLoadingOption
         *        Choose to load JSON keys mapped to table column names or choose to split the JSON payload where
         *        content is mapped to a record content column and source metadata is mapped to a record metadata
         *        column.
         * @see SnowflakeDataLoadingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowflakeDataLoadingOption
         */
        Builder dataLoadingOption(SnowflakeDataLoadingOption dataLoadingOption);

        /**
         * <p>
         * The name of the record metadata column
         * </p>
         * 
         * @param metaDataColumnName
         *        The name of the record metadata column
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaDataColumnName(String metaDataColumnName);

        /**
         * <p>
         * The name of the record content column
         * </p>
         * 
         * @param contentColumnName
         *        The name of the record content column
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentColumnName(String contentColumnName);

        /**
         * <p>
         * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
         * com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
         * href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
         * Snowflake</a>
         * </p>
         * 
         * @param snowflakeVpcConfiguration
         *        The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
         *        com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
         *        href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
         *        Snowflake</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflakeVpcConfiguration(SnowflakeVpcConfiguration snowflakeVpcConfiguration);

        /**
         * <p>
         * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
         * com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
         * href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
         * Snowflake</a>
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnowflakeVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #snowflakeVpcConfiguration(SnowflakeVpcConfiguration)}.
         * 
         * @param snowflakeVpcConfiguration
         *        a consumer that will call methods on {@link SnowflakeVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflakeVpcConfiguration(SnowflakeVpcConfiguration)
         */
        default Builder snowflakeVpcConfiguration(Consumer<SnowflakeVpcConfiguration.Builder> snowflakeVpcConfiguration) {
            return snowflakeVpcConfiguration(SnowflakeVpcConfiguration.builder().applyMutation(snowflakeVpcConfiguration).build());
        }

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * @param cloudWatchLoggingOptions
         *        The new value for the CloudWatchLoggingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * @param processingConfiguration
         *        The new value for the ProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Snowflake role
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the Snowflake role
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * </p>
         * 
         * @param retryOptions
         *        The time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(SnowflakeRetryOptions retryOptions);

        /**
         * <p>
         * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeRetryOptions.Builder} avoiding
         * the need to create one manually via {@link SnowflakeRetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeRetryOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #retryOptions(SnowflakeRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link SnowflakeRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(SnowflakeRetryOptions)
         */
        default Builder retryOptions(Consumer<SnowflakeRetryOptions.Builder> retryOptions) {
            return retryOptions(SnowflakeRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * Choose an S3 backup mode
         * </p>
         * 
         * @param s3BackupMode
         *        Choose an S3 backup mode
         * @see SnowflakeS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowflakeS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Choose an S3 backup mode
         * </p>
         * 
         * @param s3BackupMode
         *        Choose an S3 backup mode
         * @see SnowflakeS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnowflakeS3BackupMode
         */
        Builder s3BackupMode(SnowflakeS3BackupMode s3BackupMode);

        /**
         * Sets the value of the S3DestinationDescription property for this object.
         *
         * @param s3DestinationDescription
         *        The new value for the S3DestinationDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * Sets the value of the S3DestinationDescription property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationDescription.Builder}
         * avoiding the need to create one manually via {@link S3DestinationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationDescription(S3DestinationDescription)}.
         * 
         * @param s3DestinationDescription
         *        a consumer that will call methods on {@link S3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationDescription(S3DestinationDescription)
         */
        default Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return s3DestinationDescription(S3DestinationDescription.builder().applyMutation(s3DestinationDescription).build());
        }

        /**
         * <p>
         * The configuration that defines how you access secrets for Snowflake.
         * </p>
         * 
         * @param secretsManagerConfiguration
         *        The configuration that defines how you access secrets for Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration);

        /**
         * <p>
         * The configuration that defines how you access secrets for Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecretsManagerConfiguration.Builder}
         * avoiding the need to create one manually via {@link SecretsManagerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #secretsManagerConfiguration(SecretsManagerConfiguration)}.
         * 
         * @param secretsManagerConfiguration
         *        a consumer that will call methods on {@link SecretsManagerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerConfiguration(SecretsManagerConfiguration)
         */
        default Builder secretsManagerConfiguration(Consumer<SecretsManagerConfiguration.Builder> secretsManagerConfiguration) {
            return secretsManagerConfiguration(SecretsManagerConfiguration.builder().applyMutation(secretsManagerConfiguration)
                    .build());
        }

        /**
         * <p>
         * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify
         * any value, Firehose uses the default values.
         * </p>
         * 
         * @param bufferingHints
         *        Describes the buffering to perform before delivering data to the Snowflake destination. If you do not
         *        specify any value, Firehose uses the default values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(SnowflakeBufferingHints bufferingHints);

        /**
         * <p>
         * Describes the buffering to perform before delivering data to the Snowflake destination. If you do not specify
         * any value, Firehose uses the default values.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeBufferingHints.Builder} avoiding
         * the need to create one manually via {@link SnowflakeBufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeBufferingHints.Builder#build()} is called immediately
         * and its result is passed to {@link #bufferingHints(SnowflakeBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link SnowflakeBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(SnowflakeBufferingHints)
         */
        default Builder bufferingHints(Consumer<SnowflakeBufferingHints.Builder> bufferingHints) {
            return bufferingHints(SnowflakeBufferingHints.builder().applyMutation(bufferingHints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountUrl;

        private String user;

        private String database;

        private String schema;

        private String table;

        private SnowflakeRoleConfiguration snowflakeRoleConfiguration;

        private String dataLoadingOption;

        private String metaDataColumnName;

        private String contentColumnName;

        private SnowflakeVpcConfiguration snowflakeVpcConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private ProcessingConfiguration processingConfiguration;

        private String roleARN;

        private SnowflakeRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationDescription s3DestinationDescription;

        private SecretsManagerConfiguration secretsManagerConfiguration;

        private SnowflakeBufferingHints bufferingHints;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeDestinationDescription model) {
            accountUrl(model.accountUrl);
            user(model.user);
            database(model.database);
            schema(model.schema);
            table(model.table);
            snowflakeRoleConfiguration(model.snowflakeRoleConfiguration);
            dataLoadingOption(model.dataLoadingOption);
            metaDataColumnName(model.metaDataColumnName);
            contentColumnName(model.contentColumnName);
            snowflakeVpcConfiguration(model.snowflakeVpcConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            processingConfiguration(model.processingConfiguration);
            roleARN(model.roleARN);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3DestinationDescription(model.s3DestinationDescription);
            secretsManagerConfiguration(model.secretsManagerConfiguration);
            bufferingHints(model.bufferingHints);
        }

        public final String getAccountUrl() {
            return accountUrl;
        }

        public final void setAccountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
        }

        @Override
        public final Builder accountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final SnowflakeRoleConfiguration.Builder getSnowflakeRoleConfiguration() {
            return snowflakeRoleConfiguration != null ? snowflakeRoleConfiguration.toBuilder() : null;
        }

        public final void setSnowflakeRoleConfiguration(SnowflakeRoleConfiguration.BuilderImpl snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration != null ? snowflakeRoleConfiguration.build() : null;
        }

        @Override
        public final Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration;
            return this;
        }

        public final String getDataLoadingOption() {
            return dataLoadingOption;
        }

        public final void setDataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
        }

        @Override
        public final Builder dataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
            return this;
        }

        @Override
        public final Builder dataLoadingOption(SnowflakeDataLoadingOption dataLoadingOption) {
            this.dataLoadingOption(dataLoadingOption == null ? null : dataLoadingOption.toString());
            return this;
        }

        public final String getMetaDataColumnName() {
            return metaDataColumnName;
        }

        public final void setMetaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
        }

        @Override
        public final Builder metaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
            return this;
        }

        public final String getContentColumnName() {
            return contentColumnName;
        }

        public final void setContentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
        }

        @Override
        public final Builder contentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
            return this;
        }

        public final SnowflakeVpcConfiguration.Builder getSnowflakeVpcConfiguration() {
            return snowflakeVpcConfiguration != null ? snowflakeVpcConfiguration.toBuilder() : null;
        }

        public final void setSnowflakeVpcConfiguration(SnowflakeVpcConfiguration.BuilderImpl snowflakeVpcConfiguration) {
            this.snowflakeVpcConfiguration = snowflakeVpcConfiguration != null ? snowflakeVpcConfiguration.build() : null;
        }

        @Override
        public final Builder snowflakeVpcConfiguration(SnowflakeVpcConfiguration snowflakeVpcConfiguration) {
            this.snowflakeVpcConfiguration = snowflakeVpcConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final SnowflakeRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(SnowflakeRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(SnowflakeRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SnowflakeS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return s3DestinationDescription != null ? s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final SecretsManagerConfiguration.Builder getSecretsManagerConfiguration() {
            return secretsManagerConfiguration != null ? secretsManagerConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerConfiguration(SecretsManagerConfiguration.BuilderImpl secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration != null ? secretsManagerConfiguration.build() : null;
        }

        @Override
        public final Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration;
            return this;
        }

        public final SnowflakeBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(SnowflakeBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(SnowflakeBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        @Override
        public SnowflakeDestinationDescription build() {
            return new SnowflakeDestinationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
