/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the containers where the destination Apache Iceberg Tables are persisted.
 * </p>
 * <p>
 * Amazon Data Firehose is in preview release and is subject to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogConfiguration.Builder, CatalogConfiguration> {
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogARN").getter(getter(CatalogConfiguration::catalogARN)).setter(setter(Builder::catalogARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogARN;

    private CatalogConfiguration(BuilderImpl builder) {
        this.catalogARN = builder.catalogARN;
    }

    /**
     * <p>
     * Specifies the Glue catalog ARN indentifier of the destination Apache Iceberg Tables. You must specify the ARN in
     * the format <code>arn:aws:glue:region:account-id:catalog</code>.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return Specifies the Glue catalog ARN indentifier of the destination Apache Iceberg Tables. You must specify the
     *         ARN in the format <code>arn:aws:glue:region:account-id:catalog</code>. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final String catalogARN() {
        return catalogARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogConfiguration)) {
            return false;
        }
        CatalogConfiguration other = (CatalogConfiguration) obj;
        return Objects.equals(catalogARN(), other.catalogARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogConfiguration").add("CatalogARN", catalogARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogARN":
            return Optional.ofNullable(clazz.cast(catalogARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogConfiguration, T> g) {
        return obj -> g.apply((CatalogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogConfiguration> {
        /**
         * <p>
         * Specifies the Glue catalog ARN indentifier of the destination Apache Iceberg Tables. You must specify the ARN
         * in the format <code>arn:aws:glue:region:account-id:catalog</code>.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param catalogARN
         *        Specifies the Glue catalog ARN indentifier of the destination Apache Iceberg Tables. You must specify
         *        the ARN in the format <code>arn:aws:glue:region:account-id:catalog</code>. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogARN(String catalogARN);
    }

    static final class BuilderImpl implements Builder {
        private String catalogARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogConfiguration model) {
            catalogARN(model.catalogARN);
        }

        public final String getCatalogARN() {
            return catalogARN;
        }

        public final void setCatalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
        }

        @Override
        public final Builder catalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
            return this;
        }

        @Override
        public CatalogConfiguration build() {
            return new CatalogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
