/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the HTTP endpoint request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpEndpointRequestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpEndpointRequestConfiguration.Builder, HttpEndpointRequestConfiguration> {
    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentEncoding").getter(getter(HttpEndpointRequestConfiguration::contentEncodingAsString))
            .setter(setter(Builder::contentEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentEncoding").build()).build();

    private static final SdkField<List<HttpEndpointCommonAttribute>> COMMON_ATTRIBUTES_FIELD = SdkField
            .<List<HttpEndpointCommonAttribute>> builder(MarshallingType.LIST)
            .memberName("CommonAttributes")
            .getter(getter(HttpEndpointRequestConfiguration::commonAttributes))
            .setter(setter(Builder::commonAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpEndpointCommonAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpEndpointCommonAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ENCODING_FIELD,
            COMMON_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentEncoding;

    private final List<HttpEndpointCommonAttribute> commonAttributes;

    private HttpEndpointRequestConfiguration(BuilderImpl builder) {
        this.contentEncoding = builder.contentEncoding;
        this.commonAttributes = builder.commonAttributes;
    }

    /**
     * <p>
     * Firehose uses the content encoding to compress the body of a request before sending the request to the
     * destination. For more information, see <a
     * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web
     * Docs, the official Mozilla documentation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentEncoding}
     * will return {@link ContentEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentEncodingAsString}.
     * </p>
     * 
     * @return Firehose uses the content encoding to compress the body of a request before sending the request to the
     *         destination. For more information, see <a
     *         href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in
     *         MDN Web Docs, the official Mozilla documentation.
     * @see ContentEncoding
     */
    public final ContentEncoding contentEncoding() {
        return ContentEncoding.fromValue(contentEncoding);
    }

    /**
     * <p>
     * Firehose uses the content encoding to compress the body of a request before sending the request to the
     * destination. For more information, see <a
     * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web
     * Docs, the official Mozilla documentation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentEncoding}
     * will return {@link ContentEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentEncodingAsString}.
     * </p>
     * 
     * @return Firehose uses the content encoding to compress the body of a request before sending the request to the
     *         destination. For more information, see <a
     *         href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in
     *         MDN Web Docs, the official Mozilla documentation.
     * @see ContentEncoding
     */
    public final String contentEncodingAsString() {
        return contentEncoding;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommonAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommonAttributes() {
        return commonAttributes != null && !(commonAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the metadata sent to the HTTP endpoint destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommonAttributes} method.
     * </p>
     * 
     * @return Describes the metadata sent to the HTTP endpoint destination.
     */
    public final List<HttpEndpointCommonAttribute> commonAttributes() {
        return commonAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommonAttributes() ? commonAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointRequestConfiguration)) {
            return false;
        }
        HttpEndpointRequestConfiguration other = (HttpEndpointRequestConfiguration) obj;
        return Objects.equals(contentEncodingAsString(), other.contentEncodingAsString())
                && hasCommonAttributes() == other.hasCommonAttributes()
                && Objects.equals(commonAttributes(), other.commonAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpEndpointRequestConfiguration").add("ContentEncoding", contentEncodingAsString())
                .add("CommonAttributes", hasCommonAttributes() ? commonAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentEncoding":
            return Optional.ofNullable(clazz.cast(contentEncodingAsString()));
        case "CommonAttributes":
            return Optional.ofNullable(clazz.cast(commonAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointRequestConfiguration, T> g) {
        return obj -> g.apply((HttpEndpointRequestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpEndpointRequestConfiguration> {
        /**
         * <p>
         * Firehose uses the content encoding to compress the body of a request before sending the request to the
         * destination. For more information, see <a
         * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN
         * Web Docs, the official Mozilla documentation.
         * </p>
         * 
         * @param contentEncoding
         *        Firehose uses the content encoding to compress the body of a request before sending the request to the
         *        destination. For more information, see <a
         *        href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a>
         *        in MDN Web Docs, the official Mozilla documentation.
         * @see ContentEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentEncoding
         */
        Builder contentEncoding(String contentEncoding);

        /**
         * <p>
         * Firehose uses the content encoding to compress the body of a request before sending the request to the
         * destination. For more information, see <a
         * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN
         * Web Docs, the official Mozilla documentation.
         * </p>
         * 
         * @param contentEncoding
         *        Firehose uses the content encoding to compress the body of a request before sending the request to the
         *        destination. For more information, see <a
         *        href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a>
         *        in MDN Web Docs, the official Mozilla documentation.
         * @see ContentEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentEncoding
         */
        Builder contentEncoding(ContentEncoding contentEncoding);

        /**
         * <p>
         * Describes the metadata sent to the HTTP endpoint destination.
         * </p>
         * 
         * @param commonAttributes
         *        Describes the metadata sent to the HTTP endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonAttributes(Collection<HttpEndpointCommonAttribute> commonAttributes);

        /**
         * <p>
         * Describes the metadata sent to the HTTP endpoint destination.
         * </p>
         * 
         * @param commonAttributes
         *        Describes the metadata sent to the HTTP endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonAttributes(HttpEndpointCommonAttribute... commonAttributes);

        /**
         * <p>
         * Describes the metadata sent to the HTTP endpoint destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #commonAttributes(List<HttpEndpointCommonAttribute>)}.
         * 
         * @param commonAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commonAttributes(java.util.Collection<HttpEndpointCommonAttribute>)
         */
        Builder commonAttributes(Consumer<HttpEndpointCommonAttribute.Builder>... commonAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String contentEncoding;

        private List<HttpEndpointCommonAttribute> commonAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointRequestConfiguration model) {
            contentEncoding(model.contentEncoding);
            commonAttributes(model.commonAttributes);
        }

        public final String getContentEncoding() {
            return contentEncoding;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        @Override
        public final Builder contentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding(contentEncoding == null ? null : contentEncoding.toString());
            return this;
        }

        public final List<HttpEndpointCommonAttribute.Builder> getCommonAttributes() {
            List<HttpEndpointCommonAttribute.Builder> result = HttpEndpointCommonAttributesListCopier
                    .copyToBuilder(this.commonAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommonAttributes(Collection<HttpEndpointCommonAttribute.BuilderImpl> commonAttributes) {
            this.commonAttributes = HttpEndpointCommonAttributesListCopier.copyFromBuilder(commonAttributes);
        }

        @Override
        public final Builder commonAttributes(Collection<HttpEndpointCommonAttribute> commonAttributes) {
            this.commonAttributes = HttpEndpointCommonAttributesListCopier.copy(commonAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonAttributes(HttpEndpointCommonAttribute... commonAttributes) {
            commonAttributes(Arrays.asList(commonAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonAttributes(Consumer<HttpEndpointCommonAttribute.Builder>... commonAttributes) {
            commonAttributes(Stream.of(commonAttributes).map(c -> HttpEndpointCommonAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public HttpEndpointRequestConfiguration build() {
            return new HttpEndpointRequestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
