/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the schema to which you want Firehose to configure your data before it writes it to Amazon S3. This
 * parameter is required if <code>Enabled</code> is set to true.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaConfiguration.Builder, SchemaConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(SchemaConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(SchemaConfiguration::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(SchemaConfiguration::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(SchemaConfiguration::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(SchemaConfiguration::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(SchemaConfiguration::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, REGION_FIELD, VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String region;

    private final String versionId;

    private SchemaConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.region = builder.region;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The role that Firehose can use to access Amazon Web Services Glue. This role must be in the same account you use
     * for Firehose. Cross-account roles aren't allowed.
     * </p>
     * <important>
     * <p>
     * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     * <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must be
     * specified.
     * </p>
     * </important>
     * 
     * @return The role that Firehose can use to access Amazon Web Services Glue. This role must be in the same account
     *         you use for Firehose. Cross-account roles aren't allowed.</p> <important>
     *         <p>
     *         If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     *         <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value
     *         must be specified.
     *         </p>
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services account ID
     * is used by default.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services
     *         account ID is used by default.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * Specifies the name of the Amazon Web Services Glue database that contains the schema for the output data.
     * </p>
     * <important>
     * <p>
     * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     * <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value must
     * be specified.
     * </p>
     * </important>
     * 
     * @return Specifies the name of the Amazon Web Services Glue database that contains the schema for the output
     *         data.</p> <important>
     *         <p>
     *         If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     *         <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its
     *         value must be specified.
     *         </p>
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies the Amazon Web Services Glue table that contains the column information that constitutes your data
     * schema.
     * </p>
     * <important>
     * <p>
     * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     * <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value must be
     * specified.
     * </p>
     * </important>
     * 
     * @return Specifies the Amazon Web Services Glue table that contains the column information that constitutes your
     *         data schema.</p> <important>
     *         <p>
     *         If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
     *         <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value
     *         must be specified.
     *         </p>
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * If you don't specify an Amazon Web Services Region, the default is the current Region.
     * </p>
     * 
     * @return If you don't specify an Amazon Web Services Region, the default is the current Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Specifies the table version for the output data schema. If you don't specify this version ID, or if you set it to
     * <code>LATEST</code>, Firehose uses the most recent version. This means that any updates to the table are
     * automatically picked up.
     * </p>
     * 
     * @return Specifies the table version for the output data schema. If you don't specify this version ID, or if you
     *         set it to <code>LATEST</code>, Firehose uses the most recent version. This means that any updates to the
     *         table are automatically picked up.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaConfiguration)) {
            return false;
        }
        SchemaConfiguration other = (SchemaConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(region(), other.region()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaConfiguration").add("RoleARN", roleARN()).add("CatalogId", catalogId())
                .add("DatabaseName", databaseName()).add("TableName", tableName()).add("Region", region())
                .add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaConfiguration, T> g) {
        return obj -> g.apply((SchemaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaConfiguration> {
        /**
         * <p>
         * The role that Firehose can use to access Amazon Web Services Glue. This role must be in the same account you
         * use for Firehose. Cross-account roles aren't allowed.
         * </p>
         * <important>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         * <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must
         * be specified.
         * </p>
         * </important>
         * 
         * @param roleARN
         *        The role that Firehose can use to access Amazon Web Services Glue. This role must be in the same
         *        account you use for Firehose. Cross-account roles aren't allowed.</p> <important>
         *        <p>
         *        If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         *        <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its
         *        value must be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services
         * account ID is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * Specifies the name of the Amazon Web Services Glue database that contains the schema for the output data.
         * </p>
         * <important>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         * <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value
         * must be specified.
         * </p>
         * </important>
         * 
         * @param databaseName
         *        Specifies the name of the Amazon Web Services Glue database that contains the schema for the output
         *        data.</p> <important>
         *        <p>
         *        If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         *        <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its
         *        value must be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies the Amazon Web Services Glue table that contains the column information that constitutes your data
         * schema.
         * </p>
         * <important>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         * <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value
         * must be specified.
         * </p>
         * </important>
         * 
         * @param tableName
         *        Specifies the Amazon Web Services Glue table that contains the column information that constitutes
         *        your data schema.</p> <important>
         *        <p>
         *        If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the
         *        <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its
         *        value must be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * If you don't specify an Amazon Web Services Region, the default is the current Region.
         * </p>
         * 
         * @param region
         *        If you don't specify an Amazon Web Services Region, the default is the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Specifies the table version for the output data schema. If you don't specify this version ID, or if you set
         * it to <code>LATEST</code>, Firehose uses the most recent version. This means that any updates to the table
         * are automatically picked up.
         * </p>
         * 
         * @param versionId
         *        Specifies the table version for the output data schema. If you don't specify this version ID, or if
         *        you set it to <code>LATEST</code>, Firehose uses the most recent version. This means that any updates
         *        to the table are automatically picked up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String catalogId;

        private String databaseName;

        private String tableName;

        private String region;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaConfiguration model) {
            roleARN(model.roleARN);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            region(model.region);
            versionId(model.versionId);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public SchemaConfiguration build() {
            return new SchemaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
