/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessS3BackupMode;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonOpenSearchServerlessDestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationDescription> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::roleARN)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionEndpoint").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::collectionEndpoint)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::collectionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::indexName)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::bufferingHints)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::bufferingHints)).constructor(AmazonOpenSearchServerlessBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::retryOptions)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::retryOptions)).constructor(AmazonOpenSearchServerlessRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::s3BackupModeAsString)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationDescription").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::s3DestinationDescription)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::processingConfiguration)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::cloudWatchLoggingOptions)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<VpcConfigurationDescription> VPC_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfigurationDescription").getter(AmazonOpenSearchServerlessDestinationDescription.getter(AmazonOpenSearchServerlessDestinationDescription::vpcConfigurationDescription)).setter(AmazonOpenSearchServerlessDestinationDescription.setter(Builder::vpcConfigurationDescription)).constructor(VpcConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, COLLECTION_ENDPOINT_FIELD, INDEX_NAME_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_DESTINATION_DESCRIPTION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmazonOpenSearchServerlessDestinationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String collectionEndpoint;
    private final String indexName;
    private final AmazonOpenSearchServerlessBufferingHints bufferingHints;
    private final AmazonOpenSearchServerlessRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationDescription s3DestinationDescription;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final VpcConfigurationDescription vpcConfigurationDescription;

    private AmazonOpenSearchServerlessDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.collectionEndpoint = builder.collectionEndpoint;
        this.indexName = builder.indexName;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfigurationDescription = builder.vpcConfigurationDescription;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String collectionEndpoint() {
        return this.collectionEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final AmazonOpenSearchServerlessBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final AmazonOpenSearchServerlessRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final AmazonOpenSearchServerlessS3BackupMode s3BackupMode() {
        return AmazonOpenSearchServerlessS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final VpcConfigurationDescription vpcConfigurationDescription() {
        return this.vpcConfigurationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfigurationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonOpenSearchServerlessDestinationDescription)) {
            return false;
        }
        AmazonOpenSearchServerlessDestinationDescription other = (AmazonOpenSearchServerlessDestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.collectionEndpoint(), other.collectionEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.vpcConfigurationDescription(), other.vpcConfigurationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonOpenSearchServerlessDestinationDescription").add("RoleARN", (Object)this.roleARN()).add("CollectionEndpoint", (Object)this.collectionEndpoint()).add("IndexName", (Object)this.indexName()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("VpcConfigurationDescription", (Object)this.vpcConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "CollectionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.collectionEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "VpcConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("CollectionEndpoint", COLLECTION_ENDPOINT_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3DestinationDescription", S3_DESTINATION_DESCRIPTION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("VpcConfigurationDescription", VPC_CONFIGURATION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonOpenSearchServerlessDestinationDescription, T> g) {
        return obj -> g.apply((AmazonOpenSearchServerlessDestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String collectionEndpoint;
        private String indexName;
        private AmazonOpenSearchServerlessBufferingHints bufferingHints;
        private AmazonOpenSearchServerlessRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationDescription s3DestinationDescription;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private VpcConfigurationDescription vpcConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonOpenSearchServerlessDestinationDescription model) {
            this.roleARN(model.roleARN);
            this.collectionEndpoint(model.collectionEndpoint);
            this.indexName(model.indexName);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3DestinationDescription(model.s3DestinationDescription);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.vpcConfigurationDescription(model.vpcConfigurationDescription);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getCollectionEndpoint() {
            return this.collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final AmazonOpenSearchServerlessBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonOpenSearchServerlessBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonOpenSearchServerlessRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonOpenSearchServerlessRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonOpenSearchServerlessRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfigurationDescription.Builder getVpcConfigurationDescription() {
            return this.vpcConfigurationDescription != null ? this.vpcConfigurationDescription.toBuilder() : null;
        }

        public final void setVpcConfigurationDescription(VpcConfigurationDescription.BuilderImpl vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription != null ? vpcConfigurationDescription.build() : null;
        }

        @Override
        public final Builder vpcConfigurationDescription(VpcConfigurationDescription vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription;
            return this;
        }

        public AmazonOpenSearchServerlessDestinationDescription build() {
            return new AmazonOpenSearchServerlessDestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationDescription> {
        public Builder roleARN(String var1);

        public Builder collectionEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints var1);

        default public Builder bufferingHints(Consumer<AmazonOpenSearchServerlessBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((AmazonOpenSearchServerlessBufferingHints)((AmazonOpenSearchServerlessBufferingHints.Builder)AmazonOpenSearchServerlessBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(AmazonOpenSearchServerlessRetryOptions var1);

        default public Builder retryOptions(Consumer<AmazonOpenSearchServerlessRetryOptions.Builder> retryOptions) {
            return this.retryOptions((AmazonOpenSearchServerlessRetryOptions)((AmazonOpenSearchServerlessRetryOptions.Builder)AmazonOpenSearchServerlessRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(AmazonOpenSearchServerlessS3BackupMode var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder vpcConfigurationDescription(VpcConfigurationDescription var1);

        default public Builder vpcConfigurationDescription(Consumer<VpcConfigurationDescription.Builder> vpcConfigurationDescription) {
            return this.vpcConfigurationDescription((VpcConfigurationDescription)((VpcConfigurationDescription.Builder)VpcConfigurationDescription.builder().applyMutation(vpcConfigurationDescription)).build());
        }
    }
}

