/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct
 * PUT as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectPutSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectPutSourceConfiguration.Builder, DirectPutSourceConfiguration> {
    private static final SdkField<Integer> THROUGHPUT_HINT_IN_M_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputHintInMBs").getter(getter(DirectPutSourceConfiguration::throughputHintInMBs))
            .setter(setter(Builder::throughputHintInMBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputHintInMBs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(THROUGHPUT_HINT_IN_M_BS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer throughputHintInMBs;

    private DirectPutSourceConfiguration(BuilderImpl builder) {
        this.throughputHintInMBs = builder.throughputHintInMBs;
    }

    /**
     * <p>
     * The value that you configure for this parameter is for information purpose only and does not affect Firehose
     * delivery throughput limit. You can use the <a href=
     * "https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits"
     * >Firehose Limits form</a> to request a throughput limit increase.
     * </p>
     * 
     * @return The value that you configure for this parameter is for information purpose only and does not affect
     *         Firehose delivery throughput limit. You can use the <a href=
     *         "https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits"
     *         >Firehose Limits form</a> to request a throughput limit increase.
     */
    public final Integer throughputHintInMBs() {
        return throughputHintInMBs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(throughputHintInMBs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectPutSourceConfiguration)) {
            return false;
        }
        DirectPutSourceConfiguration other = (DirectPutSourceConfiguration) obj;
        return Objects.equals(throughputHintInMBs(), other.throughputHintInMBs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectPutSourceConfiguration").add("ThroughputHintInMBs", throughputHintInMBs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThroughputHintInMBs":
            return Optional.ofNullable(clazz.cast(throughputHintInMBs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ThroughputHintInMBs", THROUGHPUT_HINT_IN_M_BS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectPutSourceConfiguration, T> g) {
        return obj -> g.apply((DirectPutSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectPutSourceConfiguration> {
        /**
         * <p>
         * The value that you configure for this parameter is for information purpose only and does not affect Firehose
         * delivery throughput limit. You can use the <a href=
         * "https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits"
         * >Firehose Limits form</a> to request a throughput limit increase.
         * </p>
         * 
         * @param throughputHintInMBs
         *        The value that you configure for this parameter is for information purpose only and does not affect
         *        Firehose delivery throughput limit. You can use the <a href=
         *        "https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits"
         *        >Firehose Limits form</a> to request a throughput limit increase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputHintInMBs(Integer throughputHintInMBs);
    }

    static final class BuilderImpl implements Builder {
        private Integer throughputHintInMBs;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectPutSourceConfiguration model) {
            throughputHintInMBs(model.throughputHintInMBs);
        }

        public final Integer getThroughputHintInMBs() {
            return throughputHintInMBs;
        }

        public final void setThroughputHintInMBs(Integer throughputHintInMBs) {
            this.throughputHintInMBs = throughputHintInMBs;
        }

        @Override
        public final Builder throughputHintInMBs(Integer throughputHintInMBs) {
            this.throughputHintInMBs = throughputHintInMBs;
            return this;
        }

        @Override
        public DirectPutSourceConfiguration build() {
            return new DirectPutSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
