/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configure a Snowflake VPC
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeVpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeVpcConfiguration.Builder, SnowflakeVpcConfiguration> {
    private static final SdkField<String> PRIVATE_LINK_VPCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateLinkVpceId").getter(getter(SnowflakeVpcConfiguration::privateLinkVpceId))
            .setter(setter(Builder::privateLinkVpceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateLinkVpceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_LINK_VPCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String privateLinkVpceId;

    private SnowflakeVpcConfiguration(BuilderImpl builder) {
        this.privateLinkVpceId = builder.privateLinkVpceId;
    }

    /**
     * <p>
     * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
     * com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
     * href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
     * </p>
     * 
     * @return The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
     *         com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
     *         href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
     *         Snowflake</a>
     */
    public final String privateLinkVpceId() {
        return privateLinkVpceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privateLinkVpceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeVpcConfiguration)) {
            return false;
        }
        SnowflakeVpcConfiguration other = (SnowflakeVpcConfiguration) obj;
        return Objects.equals(privateLinkVpceId(), other.privateLinkVpceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeVpcConfiguration")
                .add("PrivateLinkVpceId", privateLinkVpceId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrivateLinkVpceId":
            return Optional.ofNullable(clazz.cast(privateLinkVpceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrivateLinkVpceId", PRIVATE_LINK_VPCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeVpcConfiguration, T> g) {
        return obj -> g.apply((SnowflakeVpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeVpcConfiguration> {
        /**
         * <p>
         * The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
         * com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
         * href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
         * Snowflake</a>
         * </p>
         * 
         * @param privateLinkVpceId
         *        The VPCE ID for Firehose to privately connect with Snowflake. The ID format is
         *        com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a
         *        href="https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp;
         *        Snowflake</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLinkVpceId(String privateLinkVpceId);
    }

    static final class BuilderImpl implements Builder {
        private String privateLinkVpceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeVpcConfiguration model) {
            privateLinkVpceId(model.privateLinkVpceId);
        }

        public final String getPrivateLinkVpceId() {
            return privateLinkVpceId;
        }

        public final void setPrivateLinkVpceId(String privateLinkVpceId) {
            this.privateLinkVpceId = privateLinkVpceId;
        }

        @Override
        public final Builder privateLinkVpceId(String privateLinkVpceId) {
            this.privateLinkVpceId = privateLinkVpceId;
            return this;
        }

        @Override
        public SnowflakeVpcConfiguration build() {
            return new SnowflakeVpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
