/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the containers where the destination Apache Iceberg Tables are persisted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CatalogConfiguration.Builder, CatalogConfiguration> {
    private static final SdkField<String> CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogARN").getter(getter(CatalogConfiguration::catalogARN)).setter(setter(Builder::catalogARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogARN").build()).build();

    private static final SdkField<String> WAREHOUSE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarehouseLocation").getter(getter(CatalogConfiguration::warehouseLocation))
            .setter(setter(Builder::warehouseLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarehouseLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ARN_FIELD,
            WAREHOUSE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalogARN;

    private final String warehouseLocation;

    private CatalogConfiguration(BuilderImpl builder) {
        this.catalogARN = builder.catalogARN;
        this.warehouseLocation = builder.warehouseLocation;
    }

    /**
     * <p>
     * Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify the ARN in
     * the format <code>arn:aws:glue:region:account-id:catalog</code>.
     * </p>
     * 
     * @return Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify the
     *         ARN in the format <code>arn:aws:glue:region:account-id:catalog</code>.
     */
    public final String catalogARN() {
        return catalogARN;
    }

    /**
     * <p>
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final String warehouseLocation() {
        return warehouseLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogARN());
        hashCode = 31 * hashCode + Objects.hashCode(warehouseLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogConfiguration)) {
            return false;
        }
        CatalogConfiguration other = (CatalogConfiguration) obj;
        return Objects.equals(catalogARN(), other.catalogARN()) && Objects.equals(warehouseLocation(), other.warehouseLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogConfiguration").add("CatalogARN", catalogARN())
                .add("WarehouseLocation", warehouseLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogARN":
            return Optional.ofNullable(clazz.cast(catalogARN()));
        case "WarehouseLocation":
            return Optional.ofNullable(clazz.cast(warehouseLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogARN", CATALOG_ARN_FIELD);
        map.put("WarehouseLocation", WAREHOUSE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogConfiguration, T> g) {
        return obj -> g.apply((CatalogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogConfiguration> {
        /**
         * <p>
         * Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify the ARN
         * in the format <code>arn:aws:glue:region:account-id:catalog</code>.
         * </p>
         * 
         * @param catalogARN
         *        Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables. You must specify
         *        the ARN in the format <code>arn:aws:glue:region:account-id:catalog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogARN(String catalogARN);

        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param warehouseLocation
         *        </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warehouseLocation(String warehouseLocation);
    }

    static final class BuilderImpl implements Builder {
        private String catalogARN;

        private String warehouseLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogConfiguration model) {
            catalogARN(model.catalogARN);
            warehouseLocation(model.warehouseLocation);
        }

        public final String getCatalogARN() {
            return catalogARN;
        }

        public final void setCatalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
        }

        @Override
        public final Builder catalogARN(String catalogARN) {
            this.catalogARN = catalogARN;
            return this;
        }

        public final String getWarehouseLocation() {
            return warehouseLocation;
        }

        public final void setWarehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public final Builder warehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
            return this;
        }

        @Override
        public CatalogConfiguration build() {
            return new CatalogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
