/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * </p>
 * <p>
 * Amazon Data Firehose is in preview release and is subject to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseSourceVPCConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseSourceVPCConfiguration.Builder, DatabaseSourceVPCConfiguration> {
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointServiceName").getter(getter(DatabaseSourceVPCConfiguration::vpcEndpointServiceName))
            .setter(setter(Builder::vpcEndpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointServiceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_ENDPOINT_SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointServiceName;

    private DatabaseSourceVPCConfiguration(BuilderImpl builder) {
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
    }

    /**
     * <p>
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final String vpcEndpointServiceName() {
        return vpcEndpointServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointServiceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseSourceVPCConfiguration)) {
            return false;
        }
        DatabaseSourceVPCConfiguration other = (DatabaseSourceVPCConfiguration) obj;
        return Objects.equals(vpcEndpointServiceName(), other.vpcEndpointServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseSourceVPCConfiguration").add("VpcEndpointServiceName", vpcEndpointServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointServiceName":
            return Optional.ofNullable(clazz.cast(vpcEndpointServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseSourceVPCConfiguration, T> g) {
        return obj -> g.apply((DatabaseSourceVPCConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseSourceVPCConfiguration> {
        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param vpcEndpointServiceName
         *        </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointServiceName(String vpcEndpointServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseSourceVPCConfiguration model) {
            vpcEndpointServiceName(model.vpcEndpointServiceName);
        }

        public final String getVpcEndpointServiceName() {
            return vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        @Override
        public DatabaseSourceVPCConfiguration build() {
            return new DatabaseSourceVPCConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
