/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify how long Firehose retries sending data to the New Relic HTTP endpoint. After sending data, Firehose first
 * waits for an acknowledgment from the HTTP endpoint. If an error occurs or the acknowledgment doesn’t arrive within
 * the acknowledgment timeout period, Firehose starts the retry duration counter. It keeps retrying until the retry
 * duration expires. After that, Firehose considers it a data delivery failure and backs up the data to your Amazon S3
 * bucket. Every time that Firehose sends data to the HTTP endpoint (either the initial attempt or a retry), it restarts
 * the acknowledgement timeout counter and waits for an acknowledgement from the HTTP endpoint. Even if the retry
 * duration expires, Firehose still waits for the acknowledgment until it receives it or the acknowledgement timeout
 * period is reached. If the acknowledgment times out, Firehose determines whether there's time left in the retry
 * counter. If there is time left, it retries again and repeats the logic until it receives an acknowledgment or
 * determines that the retry time has expired. If you don't want Firehose to retry sending data, set this value to 0.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeRetryOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeRetryOptions.Builder, SnowflakeRetryOptions> {
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(SnowflakeRetryOptions::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer durationInSeconds;

    private SnowflakeRetryOptions(BuilderImpl builder) {
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * the time period where Firehose will retry sending data to the chosen HTTP endpoint.
     * </p>
     * 
     * @return the time period where Firehose will retry sending data to the chosen HTTP endpoint.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeRetryOptions)) {
            return false;
        }
        SnowflakeRetryOptions other = (SnowflakeRetryOptions) obj;
        return Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeRetryOptions").add("DurationInSeconds", durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeRetryOptions, T> g) {
        return obj -> g.apply((SnowflakeRetryOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeRetryOptions> {
        /**
         * <p>
         * the time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * </p>
         * 
         * @param durationInSeconds
         *        the time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeRetryOptions model) {
            durationInSeconds(model.durationInSeconds);
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        @Override
        public SnowflakeRetryOptions build() {
            return new SnowflakeRetryOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
