/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents how to produce partition data for a table. Partition data is produced by transforming columns in a table.
 * Each column transform is represented by a named <code>PartitionField</code>.
 * </p>
 * <p>
 * Here is an example of the schema in JSON.
 * </p>
 * <p>
 * <code>"partitionSpec": { "identity": [ {"sourceName": "column1"}, {"sourceName": "column2"}, {"sourceName": "column3"} ] }</code>
 * </p>
 * <p>
 * Amazon Data Firehose is in preview release and is subject to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionSpec implements SdkPojo, Serializable, ToCopyableBuilder<PartitionSpec.Builder, PartitionSpec> {
    private static final SdkField<List<PartitionField>> IDENTITY_FIELD = SdkField
            .<List<PartitionField>> builder(MarshallingType.LIST)
            .memberName("Identity")
            .getter(getter(PartitionSpec::identity))
            .setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PartitionField> identity;

    private PartitionSpec(BuilderImpl builder) {
        this.identity = builder.identity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identity property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentity() {
        return identity != null && !(identity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that performs an
     * identity transformation. The transform takes the source value, and does not modify it. Result type is the source
     * type.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentity} method.
     * </p>
     * 
     * @return List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that
     *         performs an identity transformation. The transform takes the source value, and does not modify it. Result
     *         type is the source type.</p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final List<PartitionField> identity() {
        return identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentity() ? identity() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionSpec)) {
            return false;
        }
        PartitionSpec other = (PartitionSpec) obj;
        return hasIdentity() == other.hasIdentity() && Objects.equals(identity(), other.identity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartitionSpec").add("Identity", hasIdentity() ? identity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identity", IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartitionSpec, T> g) {
        return obj -> g.apply((PartitionSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionSpec> {
        /**
         * <p>
         * List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that performs
         * an identity transformation. The transform takes the source value, and does not modify it. Result type is the
         * source type.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param identity
         *        List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that
         *        performs an identity transformation. The transform takes the source value, and does not modify it.
         *        Result type is the source type.</p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(Collection<PartitionField> identity);

        /**
         * <p>
         * List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that performs
         * an identity transformation. The transform takes the source value, and does not modify it. Result type is the
         * source type.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param identity
         *        List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that
         *        performs an identity transformation. The transform takes the source value, and does not modify it.
         *        Result type is the source type.</p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(PartitionField... identity);

        /**
         * <p>
         * List of identity <a href="https://iceberg.apache.org/spec/#partition-transforms">transforms</a> that performs
         * an identity transformation. The transform takes the source value, and does not modify it. Result type is the
         * source type.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.PartitionField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.firehose.model.PartitionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.PartitionField.Builder#build()} is called immediately
         * and its result is passed to {@link #identity(List<PartitionField>)}.
         * 
         * @param identity
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.PartitionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identity(java.util.Collection<PartitionField>)
         */
        Builder identity(Consumer<PartitionField.Builder>... identity);
    }

    static final class BuilderImpl implements Builder {
        private List<PartitionField> identity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionSpec model) {
            identity(model.identity);
        }

        public final List<PartitionField.Builder> getIdentity() {
            List<PartitionField.Builder> result = PartitionFieldsCopier.copyToBuilder(this.identity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentity(Collection<PartitionField.BuilderImpl> identity) {
            this.identity = PartitionFieldsCopier.copyFromBuilder(identity);
        }

        @Override
        public final Builder identity(Collection<PartitionField> identity) {
            this.identity = PartitionFieldsCopier.copy(identity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identity(PartitionField... identity) {
            identity(Arrays.asList(identity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identity(Consumer<PartitionField.Builder>... identity) {
            identity(Stream.of(identity).map(c -> PartitionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PartitionSpec build() {
            return new PartitionSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
