/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordBatchResponse extends FirehoseResponse implements
        ToCopyableBuilder<PutRecordBatchResponse.Builder, PutRecordBatchResponse> {
    private static final SdkField<Integer> FAILED_PUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedPutCount").getter(getter(PutRecordBatchResponse::failedPutCount))
            .setter(setter(Builder::failedPutCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedPutCount").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(PutRecordBatchResponse::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<List<PutRecordBatchResponseEntry>> REQUEST_RESPONSES_FIELD = SdkField
            .<List<PutRecordBatchResponseEntry>> builder(MarshallingType.LIST)
            .memberName("RequestResponses")
            .getter(getter(PutRecordBatchResponse::requestResponses))
            .setter(setter(Builder::requestResponses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestResponses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutRecordBatchResponseEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutRecordBatchResponseEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_PUT_COUNT_FIELD,
            ENCRYPTED_FIELD, REQUEST_RESPONSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer failedPutCount;

    private final Boolean encrypted;

    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        super(builder);
        this.failedPutCount = builder.failedPutCount;
        this.encrypted = builder.encrypted;
        this.requestResponses = builder.requestResponses;
    }

    /**
     * <p>
     * The number of records that might have failed processing. This number might be greater than 0 even if the
     * <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records
     * that you need to resend.
     * </p>
     * 
     * @return The number of records that might have failed processing. This number might be greater than 0 even if the
     *         <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are
     *         records that you need to resend.
     */
    public final Integer failedPutCount() {
        return failedPutCount;
    }

    /**
     * <p>
     * Indicates whether server-side encryption (SSE) was enabled during this operation.
     * </p>
     * 
     * @return Indicates whether server-side encryption (SSE) was enabled during this operation.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestResponses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestResponses() {
        return requestResponses != null && !(requestResponses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results array. For each record, the index of the response element is the same as the index used in the
     * request array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestResponses} method.
     * </p>
     * 
     * @return The results array. For each record, the index of the response element is the same as the index used in
     *         the request array.
     */
    public final List<PutRecordBatchResponseEntry> requestResponses() {
        return requestResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedPutCount());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestResponses() ? requestResponses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse) obj;
        return Objects.equals(failedPutCount(), other.failedPutCount()) && Objects.equals(encrypted(), other.encrypted())
                && hasRequestResponses() == other.hasRequestResponses()
                && Objects.equals(requestResponses(), other.requestResponses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordBatchResponse").add("FailedPutCount", failedPutCount()).add("Encrypted", encrypted())
                .add("RequestResponses", hasRequestResponses() ? requestResponses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedPutCount":
            return Optional.ofNullable(clazz.cast(failedPutCount()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "RequestResponses":
            return Optional.ofNullable(clazz.cast(requestResponses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedPutCount", FAILED_PUT_COUNT_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("RequestResponses", REQUEST_RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordBatchResponse, T> g) {
        return obj -> g.apply((PutRecordBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRecordBatchResponse> {
        /**
         * <p>
         * The number of records that might have failed processing. This number might be greater than 0 even if the
         * <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records
         * that you need to resend.
         * </p>
         * 
         * @param failedPutCount
         *        The number of records that might have failed processing. This number might be greater than 0 even if
         *        the <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there
         *        are records that you need to resend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedPutCount(Integer failedPutCount);

        /**
         * <p>
         * Indicates whether server-side encryption (SSE) was enabled during this operation.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether server-side encryption (SSE) was enabled during this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(PutRecordBatchResponseEntry... requestResponses);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #requestResponses(List<PutRecordBatchResponseEntry>)}.
         * 
         * @param requestResponses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestResponses(java.util.Collection<PutRecordBatchResponseEntry>)
         */
        Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder>... requestResponses);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private Integer failedPutCount;

        private Boolean encrypted;

        private List<PutRecordBatchResponseEntry> requestResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            super(model);
            failedPutCount(model.failedPutCount);
            encrypted(model.encrypted);
            requestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return failedPutCount;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final List<PutRecordBatchResponseEntry.Builder> getRequestResponses() {
            List<PutRecordBatchResponseEntry.Builder> result = PutRecordBatchResponseEntryListCopier
                    .copyToBuilder(this.requestResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry.BuilderImpl> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copyFromBuilder(requestResponses);
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry... requestResponses) {
            requestResponses(Arrays.asList(requestResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder>... requestResponses) {
            requestResponses(Stream.of(requestResponses).map(c -> PutRecordBatchResponseEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
