/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration;
import software.amazon.awssdk.services.firehose.model.SnowflakeBufferingHints;
import software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption;
import software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions;
import software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration;
import software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeDestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeDestinationUpdate> {
    private static final SdkField<String> ACCOUNT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountUrl").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::accountUrl)).setter(SnowflakeDestinationUpdate.setter(Builder::accountUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountUrl").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKey").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::privateKey)).setter(SnowflakeDestinationUpdate.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final SdkField<String> KEY_PASSPHRASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPassphrase").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::keyPassphrase)).setter(SnowflakeDestinationUpdate.setter(Builder::keyPassphrase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPassphrase").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::user)).setter(SnowflakeDestinationUpdate.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::database)).setter(SnowflakeDestinationUpdate.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::schema)).setter(SnowflakeDestinationUpdate.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::table)).setter(SnowflakeDestinationUpdate.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<SnowflakeRoleConfiguration> SNOWFLAKE_ROLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnowflakeRoleConfiguration").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::snowflakeRoleConfiguration)).setter(SnowflakeDestinationUpdate.setter(Builder::snowflakeRoleConfiguration)).constructor(SnowflakeRoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeRoleConfiguration").build()}).build();
    private static final SdkField<String> DATA_LOADING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLoadingOption").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::dataLoadingOptionAsString)).setter(SnowflakeDestinationUpdate.setter(Builder::dataLoadingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLoadingOption").build()}).build();
    private static final SdkField<String> META_DATA_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetaDataColumnName").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::metaDataColumnName)).setter(SnowflakeDestinationUpdate.setter(Builder::metaDataColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaDataColumnName").build()}).build();
    private static final SdkField<String> CONTENT_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentColumnName").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::contentColumnName)).setter(SnowflakeDestinationUpdate.setter(Builder::contentColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentColumnName").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::cloudWatchLoggingOptions)).setter(SnowflakeDestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::processingConfiguration)).setter(SnowflakeDestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::roleARN)).setter(SnowflakeDestinationUpdate.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<SnowflakeRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::retryOptions)).setter(SnowflakeDestinationUpdate.setter(Builder::retryOptions)).constructor(SnowflakeRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::s3BackupModeAsString)).setter(SnowflakeDestinationUpdate.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Update").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::s3Update)).setter(SnowflakeDestinationUpdate.setter(Builder::s3Update)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()}).build();
    private static final SdkField<SecretsManagerConfiguration> SECRETS_MANAGER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManagerConfiguration").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::secretsManagerConfiguration)).setter(SnowflakeDestinationUpdate.setter(Builder::secretsManagerConfiguration)).constructor(SecretsManagerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerConfiguration").build()}).build();
    private static final SdkField<SnowflakeBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(SnowflakeDestinationUpdate.getter(SnowflakeDestinationUpdate::bufferingHints)).setter(SnowflakeDestinationUpdate.setter(Builder::bufferingHints)).constructor(SnowflakeBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_URL_FIELD, PRIVATE_KEY_FIELD, KEY_PASSPHRASE_FIELD, USER_FIELD, DATABASE_FIELD, SCHEMA_FIELD, TABLE_FIELD, SNOWFLAKE_ROLE_CONFIGURATION_FIELD, DATA_LOADING_OPTION_FIELD, META_DATA_COLUMN_NAME_FIELD, CONTENT_COLUMN_NAME_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_UPDATE_FIELD, SECRETS_MANAGER_CONFIGURATION_FIELD, BUFFERING_HINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnowflakeDestinationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountUrl;
    private final String privateKey;
    private final String keyPassphrase;
    private final String user;
    private final String database;
    private final String schema;
    private final String table;
    private final SnowflakeRoleConfiguration snowflakeRoleConfiguration;
    private final String dataLoadingOption;
    private final String metaDataColumnName;
    private final String contentColumnName;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String roleARN;
    private final SnowflakeRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3Update;
    private final SecretsManagerConfiguration secretsManagerConfiguration;
    private final SnowflakeBufferingHints bufferingHints;

    private SnowflakeDestinationUpdate(BuilderImpl builder) {
        this.accountUrl = builder.accountUrl;
        this.privateKey = builder.privateKey;
        this.keyPassphrase = builder.keyPassphrase;
        this.user = builder.user;
        this.database = builder.database;
        this.schema = builder.schema;
        this.table = builder.table;
        this.snowflakeRoleConfiguration = builder.snowflakeRoleConfiguration;
        this.dataLoadingOption = builder.dataLoadingOption;
        this.metaDataColumnName = builder.metaDataColumnName;
        this.contentColumnName = builder.contentColumnName;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Update = builder.s3Update;
        this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
        this.bufferingHints = builder.bufferingHints;
    }

    public final String accountUrl() {
        return this.accountUrl;
    }

    public final String privateKey() {
        return this.privateKey;
    }

    public final String keyPassphrase() {
        return this.keyPassphrase;
    }

    public final String user() {
        return this.user;
    }

    public final String database() {
        return this.database;
    }

    public final String schema() {
        return this.schema;
    }

    public final String table() {
        return this.table;
    }

    public final SnowflakeRoleConfiguration snowflakeRoleConfiguration() {
        return this.snowflakeRoleConfiguration;
    }

    public final SnowflakeDataLoadingOption dataLoadingOption() {
        return SnowflakeDataLoadingOption.fromValue(this.dataLoadingOption);
    }

    public final String dataLoadingOptionAsString() {
        return this.dataLoadingOption;
    }

    public final String metaDataColumnName() {
        return this.metaDataColumnName;
    }

    public final String contentColumnName() {
        return this.contentColumnName;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final SnowflakeRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final SnowflakeS3BackupMode s3BackupMode() {
        return SnowflakeS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public final SecretsManagerConfiguration secretsManagerConfiguration() {
        return this.secretsManagerConfiguration;
    }

    public final SnowflakeBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPassphrase());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflakeRoleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLoadingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metaDataColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeDestinationUpdate)) {
            return false;
        }
        SnowflakeDestinationUpdate other = (SnowflakeDestinationUpdate)obj;
        return Objects.equals(this.accountUrl(), other.accountUrl()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.keyPassphrase(), other.keyPassphrase()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.snowflakeRoleConfiguration(), other.snowflakeRoleConfiguration()) && Objects.equals(this.dataLoadingOptionAsString(), other.dataLoadingOptionAsString()) && Objects.equals(this.metaDataColumnName(), other.metaDataColumnName()) && Objects.equals(this.contentColumnName(), other.contentColumnName()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.secretsManagerConfiguration(), other.secretsManagerConfiguration()) && Objects.equals(this.bufferingHints(), other.bufferingHints());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeDestinationUpdate").add("AccountUrl", (Object)(this.accountUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyPassphrase", (Object)(this.keyPassphrase() == null ? null : "*** Sensitive Data Redacted ***")).add("User", (Object)(this.user() == null ? null : "*** Sensitive Data Redacted ***")).add("Database", (Object)(this.database() == null ? null : "*** Sensitive Data Redacted ***")).add("Schema", (Object)(this.schema() == null ? null : "*** Sensitive Data Redacted ***")).add("Table", (Object)(this.table() == null ? null : "*** Sensitive Data Redacted ***")).add("SnowflakeRoleConfiguration", (Object)this.snowflakeRoleConfiguration()).add("DataLoadingOption", (Object)this.dataLoadingOptionAsString()).add("MetaDataColumnName", (Object)(this.metaDataColumnName() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentColumnName", (Object)(this.contentColumnName() == null ? null : "*** Sensitive Data Redacted ***")).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("RoleARN", (Object)this.roleARN()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Update", (Object)this.s3Update()).add("SecretsManagerConfiguration", (Object)this.secretsManagerConfiguration()).add("BufferingHints", (Object)this.bufferingHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountUrl": {
                return Optional.ofNullable(clazz.cast(this.accountUrl()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "KeyPassphrase": {
                return Optional.ofNullable(clazz.cast(this.keyPassphrase()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "SnowflakeRoleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snowflakeRoleConfiguration()));
            }
            case "DataLoadingOption": {
                return Optional.ofNullable(clazz.cast(this.dataLoadingOptionAsString()));
            }
            case "MetaDataColumnName": {
                return Optional.ofNullable(clazz.cast(this.metaDataColumnName()));
            }
            case "ContentColumnName": {
                return Optional.ofNullable(clazz.cast(this.contentColumnName()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Update": {
                return Optional.ofNullable(clazz.cast(this.s3Update()));
            }
            case "SecretsManagerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerConfiguration()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountUrl", ACCOUNT_URL_FIELD);
        map.put("PrivateKey", PRIVATE_KEY_FIELD);
        map.put("KeyPassphrase", KEY_PASSPHRASE_FIELD);
        map.put("User", USER_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("SnowflakeRoleConfiguration", SNOWFLAKE_ROLE_CONFIGURATION_FIELD);
        map.put("DataLoadingOption", DATA_LOADING_OPTION_FIELD);
        map.put("MetaDataColumnName", META_DATA_COLUMN_NAME_FIELD);
        map.put("ContentColumnName", CONTENT_COLUMN_NAME_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Update", S3_UPDATE_FIELD);
        map.put("SecretsManagerConfiguration", SECRETS_MANAGER_CONFIGURATION_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeDestinationUpdate, T> g) {
        return obj -> g.apply((SnowflakeDestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountUrl;
        private String privateKey;
        private String keyPassphrase;
        private String user;
        private String database;
        private String schema;
        private String table;
        private SnowflakeRoleConfiguration snowflakeRoleConfiguration;
        private String dataLoadingOption;
        private String metaDataColumnName;
        private String contentColumnName;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String roleARN;
        private SnowflakeRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationUpdate s3Update;
        private SecretsManagerConfiguration secretsManagerConfiguration;
        private SnowflakeBufferingHints bufferingHints;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeDestinationUpdate model) {
            this.accountUrl(model.accountUrl);
            this.privateKey(model.privateKey);
            this.keyPassphrase(model.keyPassphrase);
            this.user(model.user);
            this.database(model.database);
            this.schema(model.schema);
            this.table(model.table);
            this.snowflakeRoleConfiguration(model.snowflakeRoleConfiguration);
            this.dataLoadingOption(model.dataLoadingOption);
            this.metaDataColumnName(model.metaDataColumnName);
            this.contentColumnName(model.contentColumnName);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.roleARN(model.roleARN);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Update(model.s3Update);
            this.secretsManagerConfiguration(model.secretsManagerConfiguration);
            this.bufferingHints(model.bufferingHints);
        }

        public final String getAccountUrl() {
            return this.accountUrl;
        }

        public final void setAccountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
        }

        @Override
        public final Builder accountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
            return this;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final String getKeyPassphrase() {
            return this.keyPassphrase;
        }

        public final void setKeyPassphrase(String keyPassphrase) {
            this.keyPassphrase = keyPassphrase;
        }

        @Override
        public final Builder keyPassphrase(String keyPassphrase) {
            this.keyPassphrase = keyPassphrase;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final SnowflakeRoleConfiguration.Builder getSnowflakeRoleConfiguration() {
            return this.snowflakeRoleConfiguration != null ? this.snowflakeRoleConfiguration.toBuilder() : null;
        }

        public final void setSnowflakeRoleConfiguration(SnowflakeRoleConfiguration.BuilderImpl snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration != null ? snowflakeRoleConfiguration.build() : null;
        }

        @Override
        public final Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration;
            return this;
        }

        public final String getDataLoadingOption() {
            return this.dataLoadingOption;
        }

        public final void setDataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
        }

        @Override
        public final Builder dataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
            return this;
        }

        @Override
        public final Builder dataLoadingOption(SnowflakeDataLoadingOption dataLoadingOption) {
            this.dataLoadingOption(dataLoadingOption == null ? null : dataLoadingOption.toString());
            return this;
        }

        public final String getMetaDataColumnName() {
            return this.metaDataColumnName;
        }

        public final void setMetaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
        }

        @Override
        public final Builder metaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
            return this;
        }

        public final String getContentColumnName() {
            return this.contentColumnName;
        }

        public final void setContentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
        }

        @Override
        public final Builder contentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final SnowflakeRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(SnowflakeRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(SnowflakeRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SnowflakeS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final SecretsManagerConfiguration.Builder getSecretsManagerConfiguration() {
            return this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerConfiguration(SecretsManagerConfiguration.BuilderImpl secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration != null ? secretsManagerConfiguration.build() : null;
        }

        @Override
        public final Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration;
            return this;
        }

        public final SnowflakeBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(SnowflakeBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(SnowflakeBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public SnowflakeDestinationUpdate build() {
            return new SnowflakeDestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeDestinationUpdate> {
        public Builder accountUrl(String var1);

        public Builder privateKey(String var1);

        public Builder keyPassphrase(String var1);

        public Builder user(String var1);

        public Builder database(String var1);

        public Builder schema(String var1);

        public Builder table(String var1);

        public Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration var1);

        default public Builder snowflakeRoleConfiguration(Consumer<SnowflakeRoleConfiguration.Builder> snowflakeRoleConfiguration) {
            return this.snowflakeRoleConfiguration((SnowflakeRoleConfiguration)((SnowflakeRoleConfiguration.Builder)SnowflakeRoleConfiguration.builder().applyMutation(snowflakeRoleConfiguration)).build());
        }

        public Builder dataLoadingOption(String var1);

        public Builder dataLoadingOption(SnowflakeDataLoadingOption var1);

        public Builder metaDataColumnName(String var1);

        public Builder contentColumnName(String var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder roleARN(String var1);

        public Builder retryOptions(SnowflakeRetryOptions var1);

        default public Builder retryOptions(Consumer<SnowflakeRetryOptions.Builder> retryOptions) {
            return this.retryOptions((SnowflakeRetryOptions)((SnowflakeRetryOptions.Builder)SnowflakeRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(SnowflakeS3BackupMode var1);

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3Update)).build());
        }

        public Builder secretsManagerConfiguration(SecretsManagerConfiguration var1);

        default public Builder secretsManagerConfiguration(Consumer<SecretsManagerConfiguration.Builder> secretsManagerConfiguration) {
            return this.secretsManagerConfiguration((SecretsManagerConfiguration)((SecretsManagerConfiguration.Builder)SecretsManagerConfiguration.builder().applyMutation(secretsManagerConfiguration)).build());
        }

        public Builder bufferingHints(SnowflakeBufferingHints var1);

        default public Builder bufferingHints(Consumer<SnowflakeBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((SnowflakeBufferingHints)((SnowflakeBufferingHints.Builder)SnowflakeBufferingHints.builder().applyMutation(bufferingHints)).build());
        }
    }
}

