/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpEndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpEndpointConfiguration.Builder, HttpEndpointConfiguration> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(HttpEndpointConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HttpEndpointConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKey").getter(getter(HttpEndpointConfiguration::accessKey)).setter(setter(Builder::accessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, NAME_FIELD,
            ACCESS_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String name;

    private final String accessKey;

    private HttpEndpointConfiguration(BuilderImpl builder) {
        this.url = builder.url;
        this.name = builder.name;
        this.accessKey = builder.accessKey;
    }

    /**
     * <p>
     * The URL of the HTTP endpoint selected as the destination.
     * </p>
     * <important>
     * <p>
     * If you choose an HTTP endpoint as your destination, review and follow the instructions in the <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
     * Delivery Request and Response Specifications</a>.
     * </p>
     * </important>
     * 
     * @return The URL of the HTTP endpoint selected as the destination.</p> <important>
     *         <p>
     *         If you choose an HTTP endpoint as your destination, review and follow the instructions in the <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP
     *         Endpoint Delivery Request and Response Specifications</a>.
     *         </p>
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The name of the HTTP endpoint selected as the destination.
     * </p>
     * 
     * @return The name of the HTTP endpoint selected as the destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
     * </p>
     * 
     * @return The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the
     *         destination.
     */
    public final String accessKey() {
        return accessKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointConfiguration)) {
            return false;
        }
        HttpEndpointConfiguration other = (HttpEndpointConfiguration) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(name(), other.name())
                && Objects.equals(accessKey(), other.accessKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpEndpointConfiguration").add("Url", url() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name()).add("AccessKey", accessKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AccessKey", ACCESS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointConfiguration, T> g) {
        return obj -> g.apply((HttpEndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpEndpointConfiguration> {
        /**
         * <p>
         * The URL of the HTTP endpoint selected as the destination.
         * </p>
         * <important>
         * <p>
         * If you choose an HTTP endpoint as your destination, review and follow the instructions in the <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP
         * Endpoint Delivery Request and Response Specifications</a>.
         * </p>
         * </important>
         * 
         * @param url
         *        The URL of the HTTP endpoint selected as the destination.</p> <important>
         *        <p>
         *        If you choose an HTTP endpoint as your destination, review and follow the instructions in the <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix -
         *        HTTP Endpoint Delivery Request and Response Specifications</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The name of the HTTP endpoint selected as the destination.
         * </p>
         * 
         * @param name
         *        The name of the HTTP endpoint selected as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the
         * destination.
         * </p>
         * 
         * @param accessKey
         *        The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(String accessKey);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String name;

        private String accessKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointConfiguration model) {
            url(model.url);
            name(model.name);
            accessKey(model.accessKey);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccessKey() {
            return accessKey;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        @Override
        public HttpEndpointConfiguration build() {
            return new HttpEndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
