/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.PartitionField;
import software.amazon.awssdk.services.firehose.model.PartitionFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionSpec> {
    private static final SdkField<List<PartitionField>> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identity").getter(PartitionSpec.getter(PartitionSpec::identity)).setter(PartitionSpec.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartitionSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PartitionField> identity;

    private PartitionSpec(BuilderImpl builder) {
        this.identity = builder.identity;
    }

    public final boolean hasIdentity() {
        return this.identity != null && !(this.identity instanceof SdkAutoConstructList);
    }

    public final List<PartitionField> identity() {
        return this.identity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentity() ? this.identity() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionSpec)) {
            return false;
        }
        PartitionSpec other = (PartitionSpec)obj;
        return this.hasIdentity() == other.hasIdentity() && Objects.equals(this.identity(), other.identity());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionSpec").add("Identity", this.hasIdentity() ? this.identity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PartitionField>>> map = new HashMap<String, SdkField<List<PartitionField>>>();
        map.put("Identity", IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartitionSpec, T> g) {
        return obj -> g.apply((PartitionSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PartitionField> identity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionSpec model) {
            this.identity(model.identity);
        }

        public final List<PartitionField.Builder> getIdentity() {
            List<PartitionField.Builder> result = PartitionFieldsCopier.copyToBuilder(this.identity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentity(Collection<PartitionField.BuilderImpl> identity) {
            this.identity = PartitionFieldsCopier.copyFromBuilder(identity);
        }

        @Override
        public final Builder identity(Collection<PartitionField> identity) {
            this.identity = PartitionFieldsCopier.copy(identity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identity(PartitionField ... identity) {
            this.identity(Arrays.asList(identity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identity(Consumer<PartitionField.Builder> ... identity) {
            this.identity(Stream.of(identity).map(c -> (PartitionField)((PartitionField.Builder)PartitionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PartitionSpec build() {
            return new PartitionSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionSpec> {
        public Builder identity(Collection<PartitionField> var1);

        public Builder identity(PartitionField ... var1);

        public Builder identity(Consumer<PartitionField.Builder> ... var1);
    }
}

