/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that defines how Firehose accesses the secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecretsManagerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SecretsManagerConfiguration.Builder, SecretsManagerConfiguration> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretARN").getter(getter(SecretsManagerConfiguration::secretARN)).setter(setter(Builder::secretARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(SecretsManagerConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(SecretsManagerConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            ROLE_ARN_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretARN;

    private final String roleARN;

    private final Boolean enabled;

    private SecretsManagerConfiguration(BuilderImpl builder) {
        this.secretARN = builder.secretARN;
        this.roleARN = builder.roleARN;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ARN of the secret that stores your credentials. It must be in the same region as the Firehose stream and the
     * role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose supports
     * cross-account secret access. This parameter is required when <b>Enabled</b> is set to <code>True</code>.
     * </p>
     * 
     * @return The ARN of the secret that stores your credentials. It must be in the same region as the Firehose stream
     *         and the role. The secret ARN can reside in a different account than the Firehose stream and role as
     *         Firehose supports cross-account secret access. This parameter is required when <b>Enabled</b> is set to
     *         <code>True</code>.
     */
    public final String secretARN() {
        return secretARN;
    }

    /**
     * <p>
     * Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you provide the
     * role, it overrides any destination specific role defined in the destination configuration. If you do not provide
     * the then we use the destination specific role. This parameter is required for Splunk.
     * </p>
     * 
     * @return Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you provide
     *         the role, it overrides any destination specific role defined in the destination configuration. If you do
     *         not provide the then we use the destination specific role. This parameter is required for Splunk.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Specifies whether you want to use the secrets manager feature. When set as <code>True</code> the secrets manager
     * configuration overwrites the existing secrets in the destination configuration. When it's set to
     * <code>False</code> Firehose falls back to the credentials in the destination configuration.
     * </p>
     * 
     * @return Specifies whether you want to use the secrets manager feature. When set as <code>True</code> the secrets
     *         manager configuration overwrites the existing secrets in the destination configuration. When it's set to
     *         <code>False</code> Firehose falls back to the credentials in the destination configuration.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerConfiguration)) {
            return false;
        }
        SecretsManagerConfiguration other = (SecretsManagerConfiguration) obj;
        return Objects.equals(secretARN(), other.secretARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecretsManagerConfiguration").add("SecretARN", secretARN()).add("RoleARN", roleARN())
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretARN":
            return Optional.ofNullable(clazz.cast(secretARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretARN", SECRET_ARN_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerConfiguration, T> g) {
        return obj -> g.apply((SecretsManagerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecretsManagerConfiguration> {
        /**
         * <p>
         * The ARN of the secret that stores your credentials. It must be in the same region as the Firehose stream and
         * the role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose
         * supports cross-account secret access. This parameter is required when <b>Enabled</b> is set to
         * <code>True</code>.
         * </p>
         * 
         * @param secretARN
         *        The ARN of the secret that stores your credentials. It must be in the same region as the Firehose
         *        stream and the role. The secret ARN can reside in a different account than the Firehose stream and
         *        role as Firehose supports cross-account secret access. This parameter is required when <b>Enabled</b>
         *        is set to <code>True</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretARN(String secretARN);

        /**
         * <p>
         * Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you provide the
         * role, it overrides any destination specific role defined in the destination configuration. If you do not
         * provide the then we use the destination specific role. This parameter is required for Splunk.
         * </p>
         * 
         * @param roleARN
         *        Specifies the role that Firehose assumes when calling the Secrets Manager API operation. When you
         *        provide the role, it overrides any destination specific role defined in the destination configuration.
         *        If you do not provide the then we use the destination specific role. This parameter is required for
         *        Splunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Specifies whether you want to use the secrets manager feature. When set as <code>True</code> the secrets
         * manager configuration overwrites the existing secrets in the destination configuration. When it's set to
         * <code>False</code> Firehose falls back to the credentials in the destination configuration.
         * </p>
         * 
         * @param enabled
         *        Specifies whether you want to use the secrets manager feature. When set as <code>True</code> the
         *        secrets manager configuration overwrites the existing secrets in the destination configuration. When
         *        it's set to <code>False</code> Firehose falls back to the credentials in the destination
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String secretARN;

        private String roleARN;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerConfiguration model) {
            secretARN(model.secretARN);
            roleARN(model.roleARN);
            enabled(model.enabled);
        }

        public final String getSecretARN() {
            return secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public SecretsManagerConfiguration build() {
            return new SecretsManagerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
