/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentActionState implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentActionState.Builder, ExperimentActionState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ExperimentActionState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ExperimentActionState::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String reason;

    private ExperimentActionState(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The state of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the action.
     * @see ExperimentActionStatus
     */
    public final ExperimentActionStatus status() {
        return ExperimentActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the action.
     * @see ExperimentActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the state.
     * </p>
     * 
     * @return The reason for the state.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentActionState)) {
            return false;
        }
        ExperimentActionState other = (ExperimentActionState) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentActionState").add("Status", statusAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentActionState, T> g) {
        return obj -> g.apply((ExperimentActionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentActionState> {
        /**
         * <p>
         * The state of the action.
         * </p>
         * 
         * @param status
         *        The state of the action.
         * @see ExperimentActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the action.
         * </p>
         * 
         * @param status
         *        The state of the action.
         * @see ExperimentActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentActionStatus
         */
        Builder status(ExperimentActionStatus status);

        /**
         * <p>
         * The reason for the state.
         * </p>
         * 
         * @param reason
         *        The reason for the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentActionState model) {
            status(model.status);
            reason(model.reason);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperimentActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public ExperimentActionState build() {
            return new ExperimentActionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
