/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an experiment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Experiment implements SdkPojo, Serializable, ToCopyableBuilder<Experiment.Builder, Experiment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Experiment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentTemplateId").getter(getter(Experiment::experimentTemplateId))
            .setter(setter(Builder::experimentTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(Experiment::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ExperimentState> STATE_FIELD = SdkField.<ExperimentState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Experiment::state)).setter(setter(Builder::state))
            .constructor(ExperimentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, ExperimentTarget>> TARGETS_FIELD = SdkField
            .<Map<String, ExperimentTarget>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(Experiment::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ExperimentAction>> ACTIONS_FIELD = SdkField
            .<Map<String, ExperimentAction>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(Experiment::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExperimentAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ExperimentStopCondition>> STOP_CONDITIONS_FIELD = SdkField
            .<List<ExperimentStopCondition>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(Experiment::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentStopCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentStopCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Experiment::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(Experiment::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(Experiment::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Experiment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ExperimentLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<ExperimentLogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(Experiment::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(ExperimentLogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            EXPERIMENT_TEMPLATE_ID_FIELD, ROLE_ARN_FIELD, STATE_FIELD, TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD,
            CREATION_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, TAGS_FIELD, LOG_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String experimentTemplateId;

    private final String roleArn;

    private final ExperimentState state;

    private final Map<String, ExperimentTarget> targets;

    private final Map<String, ExperimentAction> actions;

    private final List<ExperimentStopCondition> stopConditions;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, String> tags;

    private final ExperimentLogConfiguration logConfiguration;

    private Experiment(BuilderImpl builder) {
        this.id = builder.id;
        this.experimentTemplateId = builder.experimentTemplateId;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.tags = builder.tags;
        this.logConfiguration = builder.logConfiguration;
    }

    /**
     * <p>
     * The ID of the experiment.
     * </p>
     * 
     * @return The ID of the experiment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String experimentTemplateId() {
        return experimentTemplateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions
     * on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
     *         actions on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The state of the experiment.
     * </p>
     * 
     * @return The state of the experiment.
     */
    public final ExperimentState state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, ExperimentTarget> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, ExperimentAction> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopConditions} method.
     * </p>
     * 
     * @return The stop conditions for the experiment.
     */
    public final List<ExperimentStopCondition> stopConditions() {
        return stopConditions;
    }

    /**
     * <p>
     * The time that the experiment was created.
     * </p>
     * 
     * @return The time that the experiment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that the experiment started.
     * </p>
     * 
     * @return The time that the experiment started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the experiment ended.
     * </p>
     * 
     * @return The time that the experiment ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the experiment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for experiment logging.
     * </p>
     * 
     * @return The configuration for experiment logging.
     */
    public final ExperimentLogConfiguration logConfiguration() {
        return logConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(experimentTemplateId(), other.experimentTemplateId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(state(), other.state())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(logConfiguration(), other.logConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Experiment").add("Id", id()).add("ExperimentTemplateId", experimentTemplateId())
                .add("RoleArn", roleArn()).add("State", state()).add("Targets", hasTargets() ? targets() : null)
                .add("Actions", hasActions() ? actions() : null)
                .add("StopConditions", hasStopConditions() ? stopConditions() : null).add("CreationTime", creationTime())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Tags", hasTags() ? tags() : null)
                .add("LogConfiguration", logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "experimentTemplateId":
            return Optional.ofNullable(clazz.cast(experimentTemplateId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Experiment> {
        /**
         * <p>
         * The ID of the experiment.
         * </p>
         * 
         * @param id
         *        The ID of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param experimentTemplateId
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentTemplateId(String experimentTemplateId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
         * actions on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform
         *        service actions on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * 
         * @param state
         *        The state of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ExperimentState state);

        /**
         * <p>
         * The state of the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentState.Builder} avoiding the
         * need to create one manually via {@link ExperimentState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(ExperimentState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ExperimentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ExperimentState)
         */
        default Builder state(Consumer<ExperimentState.Builder> state) {
            return state(ExperimentState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, ExperimentTarget> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, ExperimentAction> actions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<ExperimentStopCondition> stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(ExperimentStopCondition... stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExperimentStopCondition>.Builder}
         * avoiding the need to create one manually via {@link List<ExperimentStopCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperimentStopCondition>.Builder#build()} is called
         * immediately and its result is passed to {@link #stopConditions(List<ExperimentStopCondition>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on {@link List<ExperimentStopCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(List<ExperimentStopCondition>)
         */
        Builder stopConditions(Consumer<ExperimentStopCondition.Builder>... stopConditions);

        /**
         * <p>
         * The time that the experiment was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the experiment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that the experiment started.
         * </p>
         * 
         * @param startTime
         *        The time that the experiment started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the experiment ended.
         * </p>
         * 
         * @param endTime
         *        The time that the experiment ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The tags for the experiment.
         * </p>
         * 
         * @param tags
         *        The tags for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration for experiment logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(ExperimentLogConfiguration logConfiguration);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentLogConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExperimentLogConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentLogConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logConfiguration(ExperimentLogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link ExperimentLogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(ExperimentLogConfiguration)
         */
        default Builder logConfiguration(Consumer<ExperimentLogConfiguration.Builder> logConfiguration) {
            return logConfiguration(ExperimentLogConfiguration.builder().applyMutation(logConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String experimentTemplateId;

        private String roleArn;

        private ExperimentState state;

        private Map<String, ExperimentTarget> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ExperimentAction> actions = DefaultSdkAutoConstructMap.getInstance();

        private List<ExperimentStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant startTime;

        private Instant endTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ExperimentLogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            id(model.id);
            experimentTemplateId(model.experimentTemplateId);
            roleArn(model.roleArn);
            state(model.state);
            targets(model.targets);
            actions(model.actions);
            stopConditions(model.stopConditions);
            creationTime(model.creationTime);
            startTime(model.startTime);
            endTime(model.endTime);
            tags(model.tags);
            logConfiguration(model.logConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExperimentTemplateId() {
            return experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ExperimentState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ExperimentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentState state) {
            this.state = state;
            return this;
        }

        public final Map<String, ExperimentTarget.Builder> getTargets() {
            Map<String, ExperimentTarget.Builder> result = ExperimentTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, ExperimentTarget.BuilderImpl> targets) {
            this.targets = ExperimentTargetMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, ExperimentTarget> targets) {
            this.targets = ExperimentTargetMapCopier.copy(targets);
            return this;
        }

        public final Map<String, ExperimentAction.Builder> getActions() {
            Map<String, ExperimentAction.Builder> result = ExperimentActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ExperimentAction.BuilderImpl> actions) {
            this.actions = ExperimentActionMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, ExperimentAction> actions) {
            this.actions = ExperimentActionMapCopier.copy(actions);
            return this;
        }

        public final List<ExperimentStopCondition.Builder> getStopConditions() {
            List<ExperimentStopCondition.Builder> result = ExperimentStopConditionListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<ExperimentStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<ExperimentStopCondition> stopConditions) {
            this.stopConditions = ExperimentStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(ExperimentStopCondition... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentStopCondition.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions).map(c -> ExperimentStopCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentLogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExperimentLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(ExperimentLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @Override
        public Experiment build() {
            return new Experiment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
