/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse;

public class ListTargetResourceTypesPublisher
implements SdkPublisher<ListTargetResourceTypesResponse> {
    private final FisAsyncClient client;
    private final ListTargetResourceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetResourceTypesPublisher(FisAsyncClient client, ListTargetResourceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetResourceTypesPublisher(FisAsyncClient client, ListTargetResourceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetResourceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetResourceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTargetResourceTypesResponseFetcher
    implements AsyncPageFetcher<ListTargetResourceTypesResponse> {
        private ListTargetResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTargetResourceTypesResponse> nextPage(ListTargetResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListTargetResourceTypesPublisher.this.client.listTargetResourceTypes(ListTargetResourceTypesPublisher.this.firstRequest);
            }
            return ListTargetResourceTypesPublisher.this.client.listTargetResourceTypes((ListTargetResourceTypesRequest)((Object)ListTargetResourceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

