/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateAction;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateActionMapCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateStopConditionListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTarget;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTargetMapCopier;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ExperimentTemplate.getter(ExperimentTemplate::id)).setter(ExperimentTemplate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ExperimentTemplate.getter(ExperimentTemplate::description)).setter(ExperimentTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, ExperimentTemplateTarget>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(ExperimentTemplate.getter(ExperimentTemplate::targets)).setter(ExperimentTemplate.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ExperimentTemplateAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actions").getter(ExperimentTemplate.getter(ExperimentTemplate::actions)).setter(ExperimentTemplate.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ExperimentTemplateStopCondition>> STOP_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopConditions").getter(ExperimentTemplate.getter(ExperimentTemplate::stopConditions)).setter(ExperimentTemplate.setter(Builder::stopConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateStopCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ExperimentTemplate.getter(ExperimentTemplate::creationTime)).setter(ExperimentTemplate.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(ExperimentTemplate.getter(ExperimentTemplate::lastUpdateTime)).setter(ExperimentTemplate.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ExperimentTemplate.getter(ExperimentTemplate::roleArn)).setter(ExperimentTemplate.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ExperimentTemplate.getter(ExperimentTemplate::tags)).setter(ExperimentTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String description;
    private final Map<String, ExperimentTemplateTarget> targets;
    private final Map<String, ExperimentTemplateAction> actions;
    private final List<ExperimentTemplateStopCondition> stopConditions;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String roleArn;
    private final Map<String, String> tags;

    private ExperimentTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentTemplateTarget> targets() {
        return this.targets;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentTemplateAction> actions() {
        return this.actions;
    }

    public final boolean hasStopConditions() {
        return this.stopConditions != null && !(this.stopConditions instanceof SdkAutoConstructList);
    }

    public final List<ExperimentTemplateStopCondition> stopConditions() {
        return this.stopConditions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopConditions() ? this.stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplate)) {
            return false;
        }
        ExperimentTemplate other = (ExperimentTemplate)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasStopConditions() == other.hasStopConditions() && Objects.equals(this.stopConditions(), other.stopConditions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentTemplate").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Targets", this.hasTargets() ? this.targets() : null).add("Actions", this.hasActions() ? this.actions() : null).add("StopConditions", this.hasStopConditions() ? this.stopConditions() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "stopConditions": {
                return Optional.ofNullable(clazz.cast(this.stopConditions()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplate, T> g) {
        return obj -> g.apply((ExperimentTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private Map<String, ExperimentTemplateTarget> targets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ExperimentTemplateAction> actions = DefaultSdkAutoConstructMap.getInstance();
        private List<ExperimentTemplateStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplate model) {
            this.id(model.id);
            this.description(model.description);
            this.targets(model.targets);
            this.actions(model.actions);
            this.stopConditions(model.stopConditions);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ExperimentTemplateTarget.Builder> getTargets() {
            Map<String, ExperimentTemplateTarget.Builder> result = ExperimentTemplateTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, ExperimentTemplateTarget.BuilderImpl> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Map<String, ExperimentTemplateTarget> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copy(targets);
            return this;
        }

        public final Map<String, ExperimentTemplateAction.Builder> getActions() {
            Map<String, ExperimentTemplateAction.Builder> result = ExperimentTemplateActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ExperimentTemplateAction.BuilderImpl> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Map<String, ExperimentTemplateAction> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copy(actions);
            return this;
        }

        public final List<ExperimentTemplateStopCondition.Builder> getStopConditions() {
            List<ExperimentTemplateStopCondition.Builder> result = ExperimentTemplateStopConditionListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<ExperimentTemplateStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        @Transient
        public final Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stopConditions(ExperimentTemplateStopCondition ... stopConditions) {
            this.stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder> ... stopConditions) {
            this.stopConditions(Stream.of(stopConditions).map(c -> (ExperimentTemplateStopCondition)((ExperimentTemplateStopCondition.Builder)ExperimentTemplateStopCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ExperimentTemplate build() {
            return new ExperimentTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentTemplate> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder targets(Map<String, ExperimentTemplateTarget> var1);

        public Builder actions(Map<String, ExperimentTemplateAction> var1);

        public Builder stopConditions(Collection<ExperimentTemplateStopCondition> var1);

        public Builder stopConditions(ExperimentTemplateStopCondition ... var1);

        public Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

